/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.gtfs.model;

import com.google.transit.realtime.GtfsRealtime;
import de.mfdz.MfdzRealtimeExtensions;
import java.util.Objects;
import org.opentripplanner.updater.trip.gtfs.model.TripDescriptor;

public final class AddedRoute {
    public static final int FALLBACK_ROUTE_TYPE = 3;
    private final String routeUrl;
    private final String agencyId;
    private final Integer routeType;
    private final String routeLongName;

    AddedRoute(String routeUrl, String agencyId, Integer routeType, String routeLongName) {
        this.routeUrl = routeUrl;
        this.agencyId = agencyId;
        this.routeType = routeType;
        this.routeLongName = routeLongName;
    }

    public int routeType() {
        return Objects.requireNonNullElse(this.routeType, 3);
    }

    public String routeUrl() {
        return this.routeUrl;
    }

    public String agencyId() {
        return this.agencyId;
    }

    public String routeLongName() {
        return this.routeLongName;
    }

    public static AddedRoute ofTripDescriptor(TripDescriptor tripDescriptor) {
        GtfsRealtime.TripDescriptor rawTripDescriptor = tripDescriptor.original();
        if (rawTripDescriptor.hasExtension(MfdzRealtimeExtensions.tripDescriptor)) {
            MfdzRealtimeExtensions.TripDescriptorExtension ext = (MfdzRealtimeExtensions.TripDescriptorExtension)rawTripDescriptor.getExtension(MfdzRealtimeExtensions.tripDescriptor);
            String url = ext.getRouteUrl();
            String agencyId = ext.getAgencyId();
            int routeType = ext.getRouteType();
            String routeName = ext.getRouteLongName();
            return new AddedRoute(url, agencyId, routeType, routeName);
        }
        return new AddedRoute(null, null, null, null);
    }
}

