/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.gtfs;

import com.google.transit.realtime.GtfsRealtime;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.framework.DataValidationException;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.Result;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.RealTimeTripTimes;
import org.opentripplanner.transit.model.timetable.RealTimeTripTimesBuilder;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.model.timetable.TripTimesFactory;
import org.opentripplanner.updater.spi.DataValidationExceptionMapper;
import org.opentripplanner.updater.spi.UpdateError;
import org.opentripplanner.updater.trip.gtfs.BackwardsDelayInterpolator;
import org.opentripplanner.updater.trip.gtfs.BackwardsDelayPropagationType;
import org.opentripplanner.updater.trip.gtfs.ForwardsDelayInterpolator;
import org.opentripplanner.updater.trip.gtfs.ForwardsDelayPropagationType;
import org.opentripplanner.updater.trip.gtfs.GtfsRealtimeMapper;
import org.opentripplanner.updater.trip.gtfs.StopAndStopTimeUpdate;
import org.opentripplanner.updater.trip.gtfs.TripTimesWithStopPattern;
import org.opentripplanner.updater.trip.gtfs.model.StopTimeUpdate;
import org.opentripplanner.updater.trip.gtfs.model.TripTimesPatch;
import org.opentripplanner.updater.trip.gtfs.model.TripUpdate;
import org.opentripplanner.utils.time.ServiceDateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TripTimesUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(TripTimesUpdater.class);
    private static final long MAX_ARRIVAL_DEPARTURE_TIME = 172800L;

    TripTimesUpdater() {
    }

    public static Result<TripTimesPatch, UpdateError> createUpdatedTripTimesFromGtfsRt(Timetable timetable, TripUpdate tripUpdate, ZoneId timeZone, LocalDate updateServiceDate, ForwardsDelayPropagationType forwardsDelayPropagationType, BackwardsDelayPropagationType backwardsDelayPropagationType) {
        Optional<String> optionalTripId = tripUpdate.tripDescriptor().tripId();
        if (optionalTripId.isEmpty()) {
            LOG.debug("TripDescriptor object has no TripId field");
            return Result.failure(UpdateError.noTripId(UpdateError.UpdateErrorType.TRIP_NOT_FOUND));
        }
        String tripId = optionalTripId.get();
        FeedScopedId feedScopedTripId = new FeedScopedId(timetable.getPattern().getFeedId(), tripId);
        TripTimes tripTimes = timetable.getTripTimes(feedScopedTripId);
        if (tripTimes == null) {
            LOG.debug("tripId {} not found in pattern.", (Object)tripId);
            return Result.failure(new UpdateError(feedScopedTripId, UpdateError.UpdateErrorType.TRIP_NOT_FOUND_IN_PATTERN));
        }
        LOG.trace("tripId {} found in timetable.", (Object)tripId);
        RealTimeTripTimesBuilder builder = tripTimes.createRealTimeWithoutScheduledTimes();
        tripUpdate.tripHeadsign().ifPresent(builder::withTripHeadsign);
        HashMap<Integer, PickDrop> updatedPickups = new HashMap<Integer, PickDrop>();
        HashMap<Integer, PickDrop> updatedDropoffs = new HashMap<Integer, PickDrop>();
        HashMap<Integer, String> replacedStopIndices = new HashMap<Integer, String>();
        Iterator<StopTimeUpdate> updates = tripUpdate.stopTimeUpdates().iterator();
        StopTimeUpdate update = null;
        if (!updates.hasNext()) {
            LOG.warn("Zero-length trip update to trip {}.", (Object)tripId);
        } else {
            update = updates.next();
        }
        int numStops = tripTimes.getNumStops();
        long today = ServiceDateUtils.asStartOfService((LocalDate)updateServiceDate, (ZoneId)timeZone).toEpochSecond();
        for (int i = 0; i < numStops; ++i) {
            int index2 = i;
            boolean match = false;
            if (update != null) {
                if (update.stopSequence().isPresent()) {
                    match = update.stopSequence().getAsInt() == tripTimes.gtfsSequenceOfStopIndex(i);
                } else if (update.stopId().isPresent()) {
                    match = timetable.getPattern().getStop(i).getId().getId().equals(update.stopId().get());
                }
            }
            if (!match) continue;
            update.stopHeadsign().ifPresent(x -> builder.withStopHeadsign(index2, (I18NString)x));
            update.pickup().ifPresent(x -> updatedPickups.put(index2, (PickDrop)((Object)x)));
            update.dropoff().ifPresent(x -> updatedDropoffs.put(index2, (PickDrop)((Object)x)));
            update.assignedStopId().ifPresent(x -> replacedStopIndices.put(index2, (String)x));
            GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship scheduleRelationship = update.scheduleRelationship();
            if (scheduleRelationship == GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SKIPPED) {
                updatedPickups.put(i, PickDrop.CANCELLED);
                updatedDropoffs.put(i, PickDrop.CANCELLED);
                builder.withCanceled(i);
            } else if (scheduleRelationship == GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.NO_DATA) {
                builder.withNoData(i);
            } else {
                if (!update.isArrivalValid()) {
                    LOG.debug("Arrival time at index {} of trip {} has neither a delay nor a time.", (Object)i, (Object)tripId);
                    return Result.failure(new UpdateError(feedScopedTripId, UpdateError.UpdateErrorType.INVALID_ARRIVAL_TIME, i));
                }
                if (!update.isDepartureValid()) {
                    LOG.debug("Departure time at index {} of trip {} has neither a delay nor a time.", (Object)i, (Object)tripId);
                    return Result.failure(new UpdateError(feedScopedTripId, UpdateError.UpdateErrorType.INVALID_DEPARTURE_TIME, i));
                }
                TripTimesUpdater.setArrivalAndDeparture(builder, i, update, today);
            }
            update = updates.hasNext() ? updates.next() : null;
        }
        if (update != null) {
            LOG.debug("Part of a TripUpdate object could not be applied successfully to trip {}.", (Object)tripId);
            return Result.failure(new UpdateError(feedScopedTripId, UpdateError.UpdateErrorType.INVALID_STOP_SEQUENCE));
        }
        if (ForwardsDelayInterpolator.getInstance(forwardsDelayPropagationType).interpolateDelay(builder)) {
            LOG.debug("Interpolated delays for for missing stops on trip {}.", (Object)tripId);
        }
        OptionalInt backwardPropagationIndex = BackwardsDelayInterpolator.getInstance(backwardsDelayPropagationType).propagateBackwards(builder);
        backwardPropagationIndex.ifPresent(index -> LOG.debug("Propagated delay from stop index {} backwards on trip {}.", (Object)index, (Object)tripId));
        TripTimesUpdater.getWheelchairAccessibility(tripUpdate).ifPresent(builder::withWheelchairAccessibility);
        builder.withRealTimeState(RealTimeState.UPDATED);
        try {
            RealTimeTripTimes result = builder.build();
            LOG.trace("A valid TripUpdate object was applied to trip {} using the Timetable class update method.", (Object)tripId);
            return Result.success(new TripTimesPatch(result, updatedPickups, updatedDropoffs, replacedStopIndices));
        }
        catch (DataValidationException e) {
            return DataValidationExceptionMapper.toResult(e);
        }
    }

    public static Result<TripTimesWithStopPattern, UpdateError> createNewTripTimesFromGtfsRt(Trip trip, @Nullable Accessibility wheelchairAccessibility, List<StopAndStopTimeUpdate> stopAndStopTimeUpdates, ZoneId timeZone, LocalDate serviceDate, RealTimeState realTimeState, @Nullable I18NString tripHeadsign, Deduplicator deduplicator, int serviceCode) {
        long midnightSecondsSinceEpoch = ServiceDateUtils.asStartOfService((LocalDate)serviceDate, (ZoneId)timeZone).toEpochSecond();
        ArrayList<StopTime> stopTimes = new ArrayList<StopTime>(stopAndStopTimeUpdates.size());
        int lastStopSequence = -1;
        for (StopAndStopTimeUpdate item : stopAndStopTimeUpdates) {
            OptionalLong departure;
            StopTimeUpdate update = item.stopTimeUpdate();
            StopLocation stop = item.stop();
            OptionalInt stopSequence = update.stopSequence();
            if (stopSequence.isPresent()) {
                int seq = stopSequence.getAsInt();
                if (seq < 0) {
                    LOG.debug("{} trip {} on {} contains negative stop sequence, skipping.", new Object[]{realTimeState, trip.getId(), serviceDate});
                    return UpdateError.result(trip.getId(), UpdateError.UpdateErrorType.INVALID_STOP_SEQUENCE);
                }
                if (seq <= lastStopSequence) {
                    LOG.debug("{} trip {} on {} contains decreasing stop sequence, skipping.", new Object[]{realTimeState, trip.getId(), serviceDate});
                    return UpdateError.result(trip.getId(), UpdateError.UpdateErrorType.INVALID_STOP_SEQUENCE);
                }
                lastStopSequence = seq;
            }
            StopTime stopTime = new StopTime();
            stopTime.setTrip(trip);
            stopTime.setStop(stop);
            OptionalLong arrival = update.scheduledArrivalTimeWithRealTimeFallback();
            if (arrival.isPresent()) {
                long arrivalTime = arrival.getAsLong() - midnightSecondsSinceEpoch;
                if (arrivalTime < 0L || arrivalTime > 172800L) {
                    LOG.debug("NEW trip {} on {} has invalid arrival time (compared to start date in TripDescriptor), skipping.", (Object)trip.getId(), (Object)serviceDate);
                    return UpdateError.result(trip.getId(), UpdateError.UpdateErrorType.INVALID_ARRIVAL_TIME);
                }
                stopTime.setArrivalTime((int)arrivalTime);
            }
            if ((departure = update.scheduledDepartureTimeWithRealTimeFallback()).isPresent()) {
                long departureTime = departure.getAsLong() - midnightSecondsSinceEpoch;
                if (departureTime < 0L || departureTime > 172800L) {
                    LOG.debug("NEW trip {} on {} has invalid departure time (compared to start date in TripDescriptor), skipping.", (Object)trip.getId(), (Object)serviceDate);
                    return UpdateError.result(trip.getId(), UpdateError.UpdateErrorType.INVALID_DEPARTURE_TIME);
                }
                stopTime.setDepartureTime((int)departureTime);
            }
            stopTime.setTimepoint(1);
            stopSequence.ifPresent(stopTime::setStopSequence);
            stopTime.setPickupType(update.effectivePickup());
            stopTime.setDropOffType(update.effectiveDropoff());
            update.stopHeadsign().ifPresent(stopTime::setStopHeadsign);
            stopTimes.add(stopTime);
        }
        RealTimeTripTimesBuilder builder = TripTimesFactory.tripTimes(trip, stopTimes, deduplicator).createRealTimeFromScheduledTimes();
        if (tripHeadsign != null) {
            builder.withTripHeadsign(tripHeadsign);
        }
        for (int stopIndex = 0; stopIndex < builder.numberOfStops(); ++stopIndex) {
            StopTimeUpdate addedStopTime = stopAndStopTimeUpdates.get(stopIndex).stopTimeUpdate();
            if (addedStopTime.isSkipped()) {
                builder.withCanceled(stopIndex);
            }
            TripTimesUpdater.setArrivalAndDeparture(builder, stopIndex, addedStopTime, midnightSecondsSinceEpoch);
            if (builder.getArrivalTime(stopIndex) == null) {
                builder.withArrivalDelay(stopIndex, 0);
            }
            if (builder.getDepartureTime(stopIndex) != null) continue;
            builder.withDepartureDelay(stopIndex, 0);
        }
        builder.withServiceCode(serviceCode);
        builder.withRealTimeState(realTimeState);
        if (wheelchairAccessibility != null) {
            builder.withWheelchairAccessibility(wheelchairAccessibility);
        }
        RealTimeTripTimes tripTimes = builder.build();
        return Result.success(new TripTimesWithStopPattern(tripTimes, new StopPattern(stopTimes)));
    }

    private static void setArrivalAndDeparture(RealTimeTripTimesBuilder builder, int stopPositionInPattern, StopTimeUpdate update, long midnightSecondsSinceEpoch) {
        OptionalLong arrivalTime = update.arrivalTime();
        OptionalLong departureTime = update.departureTime();
        OptionalInt arrivalDelay = update.arrivalDelay();
        OptionalInt departureDelay = update.departureDelay();
        arrivalTime.ifPresentOrElse(time -> builder.withArrivalTime(stopPositionInPattern, (int)(time - midnightSecondsSinceEpoch)), () -> arrivalDelay.ifPresent(delay -> builder.withArrivalDelay(stopPositionInPattern, delay)));
        departureTime.ifPresentOrElse(time -> builder.withDepartureTime(stopPositionInPattern, (int)(time - midnightSecondsSinceEpoch)), () -> departureDelay.ifPresent(delay -> builder.withDepartureDelay(stopPositionInPattern, delay)));
    }

    static Optional<Accessibility> getWheelchairAccessibility(TripUpdate tripUpdate) {
        return tripUpdate.vehicle().flatMap(vehicleDescriptor -> vehicleDescriptor.hasWheelchairAccessible() ? GtfsRealtimeMapper.mapWheelchairAccessible(vehicleDescriptor.getWheelchairAccessible()) : Optional.empty());
    }
}

