/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.gtfs;

import java.util.HashMap;
import java.util.Map;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.Direction;
import org.opentripplanner.transit.model.timetable.Trip;

class TripPatternCache {
    private final Map<StopPattern, TripPattern> cache = new HashMap<StopPattern, TripPattern>();
    private int counter = 0;

    TripPatternCache() {
    }

    public synchronized TripPattern getOrCreateTripPattern(StopPattern stopPattern, Trip trip, TripPattern originalTripPattern) {
        Route route = trip.getRoute();
        TripPattern tripPattern = this.cache.get(stopPattern);
        if (tripPattern == null) {
            FeedScopedId id = this.generateUniqueTripPatternCode(trip);
            tripPattern = (TripPattern)TripPattern.of(id).withRoute(route).withMode(trip.getMode()).withNetexSubmode(trip.getNetexSubMode()).withStopPattern(stopPattern).withCreatedByRealtimeUpdater(true).withOriginalTripPattern(originalTripPattern).build();
            this.cache.put(stopPattern, tripPattern);
        }
        return tripPattern;
    }

    private FeedScopedId generateUniqueTripPatternCode(Trip trip) {
        String directionId;
        FeedScopedId routeId = trip.getRoute().getId();
        Direction direction = trip.getDirection();
        String string = directionId = direction == Direction.UNKNOWN ? "" : Integer.toString(direction.gtfsCode);
        this.counter = this.counter == Integer.MAX_VALUE ? 0 : ++this.counter;
        String code = String.format("%s:%s:rt#%d", routeId.getId(), directionId, this.counter);
        return new FeedScopedId(routeId.getFeedId(), code);
    }
}

