/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.gtfs;

import com.google.transit.realtime.GtfsRealtime;
import gnu.trove.set.TIntSet;
import java.text.ParseException;
import java.time.LocalDate;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.gtfs.mapping.DirectionMapper;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.Direction;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.utils.time.ServiceDateUtils;
import org.opentripplanner.utils.time.TimeUtils;

public class GtfsRealtimeFuzzyTripMatcher {
    private final TransitService transitService;
    private final DirectionMapper directionMapper = new DirectionMapper(DataImportIssueStore.NOOP);

    public GtfsRealtimeFuzzyTripMatcher(TransitService transitService) {
        this.transitService = transitService;
    }

    public GtfsRealtime.TripDescriptor match(String feedId, GtfsRealtime.TripDescriptor trip) {
        LocalDate date;
        if (trip.hasTripId() && this.transitService.containsTrip(new FeedScopedId(feedId, trip.getTripId()))) {
            return trip;
        }
        if (!(trip.hasRouteId() && trip.hasDirectionId() && trip.hasStartTime() && trip.hasStartDate())) {
            return trip;
        }
        FeedScopedId routeId = new FeedScopedId(feedId, trip.getRouteId());
        int time = TimeUtils.time((String)trip.getStartTime());
        try {
            date = ServiceDateUtils.parseString((String)trip.getStartDate());
        }
        catch (ParseException e) {
            return trip;
        }
        Route route = this.transitService.getRoute(routeId);
        if (route == null) {
            return trip;
        }
        Direction direction = this.directionMapper.map(trip.getDirectionId());
        Trip matchedTrip = this.getTrip(route, direction, time, date);
        if (matchedTrip == null) {
            date = date.minusDays(1L);
            matchedTrip = this.getTrip(route, direction, time += 86400, date);
        }
        if (matchedTrip == null) {
            return trip;
        }
        return trip.toBuilder().setTripId(matchedTrip.getId().getId()).build();
    }

    public synchronized Trip getTrip(Route route, Direction direction, int startTime, LocalDate date) {
        TIntSet servicesRunningForDate = this.transitService.getServiceCodesRunningForDate(date);
        for (TripPattern pattern : this.transitService.findPatterns(route)) {
            if (pattern.getDirection() != direction) continue;
            for (TripTimes times : pattern.getScheduledTimetable().getTripTimes()) {
                if (times.getScheduledDepartureTime(0) != startTime || !servicesRunningForDate.contains(times.getServiceCode())) continue;
                return times.getTrip();
            }
        }
        return null;
    }
}

