/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.gtfs;

import java.util.Objects;
import org.opentripplanner.transit.model.timetable.RealTimeTripTimesBuilder;
import org.opentripplanner.transit.model.timetable.StopRealTimeState;
import org.opentripplanner.updater.trip.gtfs.ForwardsDelayInterpolator;

class DefaultForwardsDelayInterpolator
implements ForwardsDelayInterpolator {
    DefaultForwardsDelayInterpolator() {
    }

    @Override
    public boolean interpolateDelay(RealTimeTripTimesBuilder builder) {
        int i;
        Integer delay = null;
        Integer time = null;
        StopRealTimeState propagatedState = StopRealTimeState.DEFAULT;
        Integer firstCanceledStop = null;
        boolean updated = false;
        for (i = 0; i < builder.numberOfStops(); ++i) {
            Integer prevDeparture;
            boolean noTimeGiven;
            boolean bl = noTimeGiven = builder.getArrivalTime(i) == null && builder.getDepartureTime(i) == null;
            if (noTimeGiven) {
                if (builder.getStopRealTimeState(i) == StopRealTimeState.DEFAULT) {
                    builder.withStopRealTimeState(i, propagatedState);
                }
                if (builder.getStopRealTimeState(i) == StopRealTimeState.CANCELLED) {
                    if (firstCanceledStop != null) continue;
                    firstCanceledStop = i;
                    continue;
                }
            }
            if (builder.getArrivalDelay(i) == null) {
                if (builder.getStopRealTimeState(i) == StopRealTimeState.NO_DATA) {
                    if (time != null && builder.getScheduledArrivalTime(i) < time) {
                        builder.withArrivalTime(i, time);
                    } else {
                        builder.withArrivalDelay(i, 0);
                    }
                } else if (delay != null) {
                    Integer departureTime = builder.getDepartureTime(i);
                    if (departureTime != null && builder.getScheduledArrivalTime(i) + delay > departureTime) {
                        builder.withArrivalTime(i, departureTime);
                    } else {
                        builder.withArrivalDelay(i, delay);
                    }
                }
                updated = true;
            }
            time = builder.getArrivalTime(i);
            delay = builder.getArrivalDelay(i);
            if (builder.getDepartureDelay(i) == null) {
                if (builder.getStopRealTimeState(i) == StopRealTimeState.NO_DATA) {
                    if (time != null && builder.getScheduledDepartureTime(i) < time) {
                        builder.withDepartureTime(i, time);
                    } else {
                        builder.withDepartureDelay(i, 0);
                    }
                } else if (delay != null) {
                    builder.withDepartureDelay(i, delay);
                }
                updated = true;
            }
            time = builder.getDepartureTime(i);
            delay = builder.getDepartureDelay(i);
            if (firstCanceledStop != null && firstCanceledStop > 0 && (prevDeparture = builder.getDepartureTime(firstCanceledStop - 1)) != null) {
                int arrival = Objects.requireNonNull(builder.getArrivalTime(i));
                int prevScheduledDeparture = builder.getScheduledDepartureTime(firstCanceledStop - 1);
                int scheduledArrival = builder.getScheduledArrivalTime(i);
                int scheduledTravelTime = Math.max(scheduledArrival - prevScheduledDeparture, 1);
                int realTimeTravelTime = arrival - prevDeparture;
                double travelTimeRatio = (double)realTimeTravelTime / (double)scheduledTravelTime;
                for (int cancelledIndex = firstCanceledStop.intValue(); cancelledIndex < i; ++cancelledIndex) {
                    int scheduledArrivalCancelled = builder.getScheduledArrivalTime(cancelledIndex);
                    int scheduledDepartureCancelled = builder.getScheduledDepartureTime(cancelledIndex);
                    int scheduledArrivalDiff = scheduledArrivalCancelled - prevScheduledDeparture;
                    double interpolatedArrival = (double)prevDeparture.intValue() + travelTimeRatio * (double)scheduledArrivalDiff;
                    int scheduledDepartureDiff = scheduledDepartureCancelled - prevScheduledDeparture;
                    double interpolatedDeparture = (double)prevDeparture.intValue() + travelTimeRatio * (double)scheduledDepartureDiff;
                    builder.withArrivalTime(cancelledIndex, (int)interpolatedArrival);
                    builder.withDepartureTime(cancelledIndex, (int)interpolatedDeparture);
                    updated = true;
                }
            }
            firstCanceledStop = null;
            StopRealTimeState state = builder.getStopRealTimeState(i);
            propagatedState = state == StopRealTimeState.NO_DATA || state == StopRealTimeState.INACCURATE_PREDICTIONS ? state : StopRealTimeState.DEFAULT;
        }
        if (delay != null && firstCanceledStop != null) {
            for (i = firstCanceledStop.intValue(); i < builder.numberOfStops(); ++i) {
                builder.withArrivalDelay(i, delay);
                builder.withDepartureDelay(i, delay);
                updated = true;
            }
        }
        if (delay == null) {
            return builder.copyMissingTimesFromScheduledTimetable();
        }
        return updated;
    }
}

