/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.gtfs;

import java.util.Objects;
import org.opentripplanner.transit.model.timetable.RealTimeTripTimesBuilder;
import org.opentripplanner.transit.model.timetable.StopRealTimeState;
import org.opentripplanner.updater.trip.gtfs.AbstractBackwardsDelayInterpolator;

class BackwardsDelayRequiredInterpolator
extends AbstractBackwardsDelayInterpolator {
    private final boolean setNoData;

    BackwardsDelayRequiredInterpolator(boolean setNoData) {
        this.setNoData = setNoData;
    }

    @Override
    protected void fillInMissingTimes(RealTimeTripTimesBuilder builder, int firstUpdatedIndex) {
        while (builder.getArrivalDelay(firstUpdatedIndex) == null && builder.getDepartureDelay(firstUpdatedIndex) == null) {
            ++firstUpdatedIndex;
        }
        Integer time = builder.getArrivalTime(firstUpdatedIndex);
        if (time == null) {
            time = Math.min(Objects.requireNonNull(builder.getDepartureTime(firstUpdatedIndex)), builder.getScheduledArrivalTime(firstUpdatedIndex));
            builder.withArrivalTime(firstUpdatedIndex, time);
        }
        for (int i = firstUpdatedIndex - 1; i >= 0; --i) {
            if (this.setNoData && builder.stopRealTimeStates()[i] != StopRealTimeState.CANCELLED) {
                builder.withNoData(i);
            }
            time = Math.min(time, builder.getScheduledDepartureTime(i));
            builder.withDepartureTime(i, time);
            time = Math.min(time, builder.getScheduledArrivalTime(i));
            builder.withArrivalTime(i, time);
        }
    }
}

