/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip.gtfs;

import java.util.OptionalInt;
import org.opentripplanner.transit.model.timetable.RealTimeTripTimesBuilder;
import org.opentripplanner.updater.trip.gtfs.BackwardsDelayInterpolator;

abstract class AbstractBackwardsDelayInterpolator
implements BackwardsDelayInterpolator {
    AbstractBackwardsDelayInterpolator() {
    }

    @Override
    public OptionalInt propagateBackwards(RealTimeTripTimesBuilder builder) {
        if (builder.getArrivalDelay(0) != null) {
            return OptionalInt.empty();
        }
        int firstUpdatedIndex = this.getFirstUpdatedIndex(builder);
        this.fillInMissingTimes(builder, firstUpdatedIndex);
        return OptionalInt.of(firstUpdatedIndex);
    }

    protected int getFirstUpdatedIndex(RealTimeTripTimesBuilder builder) {
        int firstUpdatedIndex = 0;
        while (builder.getArrivalDelay(firstUpdatedIndex) == null && builder.getDepartureDelay(firstUpdatedIndex) == null) {
            if (++firstUpdatedIndex != builder.numberOfStops()) continue;
            throw new IllegalArgumentException("No real-time updates exist in the builder, can't propagate backwards.");
        }
        return firstUpdatedIndex;
    }

    protected abstract void fillInMissingTimes(RealTimeTripTimesBuilder var1, int var2);
}

