/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip;

import java.time.LocalDate;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.opentripplanner.model.RealTimeTripUpdate;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TimetableSnapshot;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.RealTimeRaptorTransitDataUpdater;
import org.opentripplanner.routing.util.ConcurrentPublished;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.Result;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.updater.TimetableSnapshotParameters;
import org.opentripplanner.updater.spi.UpdateError;
import org.opentripplanner.updater.spi.UpdateSuccess;

public final class TimetableSnapshotManager {
    private final RealTimeRaptorTransitDataUpdater realtimeRaptorTransitDataUpdater;
    private final TimetableSnapshot buffer = new TimetableSnapshot();
    private final ConcurrentPublished<TimetableSnapshot> snapshot = new ConcurrentPublished();
    private final boolean purgeExpiredData;
    private final Supplier<LocalDate> localDateNow;
    private LocalDate lastPurgeDate = null;

    public TimetableSnapshotManager(@Nullable RealTimeRaptorTransitDataUpdater realtimeRaptorTransitDataUpdater, TimetableSnapshotParameters parameters, Supplier<LocalDate> localDateNow) {
        this.realtimeRaptorTransitDataUpdater = realtimeRaptorTransitDataUpdater;
        this.purgeExpiredData = parameters.purgeExpiredData();
        this.localDateNow = Objects.requireNonNull(localDateNow);
        this.commitTimetableSnapshot(true);
    }

    public TimetableSnapshot getTimetableSnapshot() {
        return this.snapshot.get();
    }

    public TimetableSnapshot getTimetableSnapshotBuffer() {
        return this.buffer;
    }

    void commitTimetableSnapshot(boolean force) {
        if (force || this.buffer.isDirty()) {
            this.snapshot.publish(this.buffer.commit(this.realtimeRaptorTransitDataUpdater, force));
        }
    }

    @Nullable
    public TripPattern getNewTripPatternForModifiedTrip(FeedScopedId tripId, LocalDate serviceDate) {
        return this.buffer.getNewTripPatternForModifiedTrip(tripId, serviceDate);
    }

    public void purgeAndCommit() {
        if (this.purgeExpiredData) {
            boolean modified = this.purgeExpiredData();
            this.commitTimetableSnapshot(modified);
        } else {
            this.commitTimetableSnapshot(false);
        }
    }

    public void revertTripToScheduledTripPattern(FeedScopedId tripId, LocalDate serviceDate) {
        this.buffer.revertTripToScheduledTripPattern(tripId, serviceDate);
    }

    private boolean purgeExpiredData() {
        LocalDate today = this.localDateNow.get();
        LocalDate previously = today.minusDays(2L);
        if (this.lastPurgeDate != null && this.lastPurgeDate.compareTo(previously) >= 0) {
            return false;
        }
        this.lastPurgeDate = previously;
        return this.buffer.purgeExpiredData(previously);
    }

    public void clearBuffer(String feedId) {
        this.buffer.clear(feedId);
    }

    public Result<UpdateSuccess, UpdateError> updateBuffer(RealTimeTripUpdate realTimeTripUpdate) {
        return this.buffer.update(realTimeTripUpdate);
    }

    public Timetable resolve(TripPattern pattern, LocalDate serviceDate) {
        return this.buffer.resolve(pattern, serviceDate);
    }
}

