/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.support.siri;

import jakarta.xml.bind.JAXBException;
import java.time.Duration;
import java.util.Optional;
import org.opentripplanner.framework.io.OtpHttpClient;
import org.opentripplanner.framework.io.OtpHttpClientFactory;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.opentripplanner.updater.support.siri.SiriHelper;
import org.opentripplanner.updater.support.siri.SiriLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri21.Siri;

public class SiriHttpLoader
implements SiriLoader {
    private static final Logger LOG = LoggerFactory.getLogger(SiriHttpLoader.class);
    private final HttpHeaders requestHeaders;
    private final String url;
    private final Duration timeout;
    private final Duration previewInterval;
    private final OtpHttpClient otpHttpClient;

    public SiriHttpLoader(String url, Duration timeout, HttpHeaders requestHeaders) {
        this(url, timeout, requestHeaders, null);
    }

    public SiriHttpLoader(String url, Duration timeout, HttpHeaders requestHeaders, Duration previewInterval) {
        this.url = url;
        this.timeout = timeout;
        this.requestHeaders = requestHeaders;
        this.previewInterval = previewInterval;
        this.otpHttpClient = new OtpHttpClientFactory(timeout, timeout).create(LOG);
    }

    @Override
    public Optional<Siri> fetchSXFeed(String requestorRef) throws JAXBException {
        RequestTimer requestTimer = new RequestTimer("SX");
        requestTimer.init();
        String sxServiceRequest = SiriHelper.createSXServiceRequestAsXml(requestorRef);
        requestTimer.serviceRequestCreated();
        return this.fetchFeed(sxServiceRequest, requestTimer, requestorRef);
    }

    @Override
    public Optional<Siri> fetchETFeed(String requestorRef) throws JAXBException {
        RequestTimer requestTimer = new RequestTimer("ET");
        requestTimer.init();
        String etServiceRequest = SiriHelper.createETServiceRequestAsXml(requestorRef, this.previewInterval);
        requestTimer.serviceRequestCreated();
        return this.fetchFeed(etServiceRequest, requestTimer, requestorRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Siri> fetchFeed(String serviceRequest, RequestTimer requestTimer, String requestorRef) {
        Optional optional;
        try {
            optional = this.otpHttpClient.postXmlAndMap(this.url, serviceRequest, this.timeout, this.requestHeaders.asMap(), is -> {
                requestTimer.responseFetched();
                Siri siri = SiriHelper.unmarshal(is);
                requestTimer.responseUnmarshalled();
                return Optional.of(siri);
            });
        }
        catch (Throwable throwable) {
            LOG.info("Updating SIRI-{} [{}]: Create req: {} ms, Fetching data: {} ms, Unmarshalling: {} ms", new Object[]{requestTimer.feedType, requestorRef, requestTimer.creating(), requestTimer.fetching(), requestTimer.unmarshalling()});
            throw throwable;
        }
        LOG.info("Updating SIRI-{} [{}]: Create req: {} ms, Fetching data: {} ms, Unmarshalling: {} ms", new Object[]{requestTimer.feedType, requestorRef, requestTimer.creating(), requestTimer.fetching(), requestTimer.unmarshalling()});
        return optional;
    }

    private static final class RequestTimer {
        private final String feedType;
        private long initAt;
        private long createdAt;
        private long fetchedAt;
        private long unmarshalledAt;

        RequestTimer(String feedType) {
            this.feedType = feedType;
        }

        void init() {
            this.initAt = System.currentTimeMillis();
        }

        void serviceRequestCreated() {
            this.createdAt = System.currentTimeMillis();
        }

        void responseFetched() {
            this.fetchedAt = System.currentTimeMillis();
        }

        void responseUnmarshalled() {
            this.unmarshalledAt = System.currentTimeMillis();
        }

        long creating() {
            return this.createdAt - this.initAt;
        }

        long fetching() {
            return this.fetchedAt - this.createdAt;
        }

        long unmarshalling() {
            return this.unmarshalledAt - this.fetchedAt;
        }
    }
}

