/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.support.siri;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import org.opentripplanner.updater.support.siri.SiriHelper;
import org.opentripplanner.updater.support.siri.SiriLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri21.Siri;

public class SiriFileLoader
implements SiriLoader {
    private static final Logger LOG = LoggerFactory.getLogger(SiriFileLoader.class);
    public static final String SUFFIX_IN_PROGRESS = ".inProgress";
    public static final String SUFFIX_OK = ".ok";
    public static final String SUFFIX_FAILED = ".failed";
    private final File directory;

    public SiriFileLoader(String url) {
        try {
            this.directory = new File(new URL(url).toURI());
            if (!this.directory.exists() || !this.directory.isDirectory()) {
                throw new IllegalArgumentException("Could not find directory: " + url);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static boolean matchesUrl(String url) {
        return url.startsWith("file:");
    }

    @Override
    public Optional<Siri> fetchSXFeed(String requestorRef) {
        return this.fetchFeed();
    }

    @Override
    public Optional<Siri> fetchETFeed(String requestorRef) {
        return this.fetchFeed();
    }

    private Optional<Siri> fetchFeed() {
        File[] files = this.directory.listFiles();
        if (files == null) {
            return Optional.empty();
        }
        for (File file : files) {
            Optional<Siri> optional;
            if (!SiriFileLoader.matchFilename(file)) continue;
            LOG.info("Process real-time input file: " + file.getAbsolutePath());
            File inProgressFile = SiriFileLoader.newFile(file, SUFFIX_IN_PROGRESS);
            file.renameTo(inProgressFile);
            Siri siri = null;
            FileInputStream is = new FileInputStream(inProgressFile);
            try {
                siri = SiriHelper.unmarshal(is);
                inProgressFile.renameTo(SiriFileLoader.newFile(file, SUFFIX_OK));
                optional = Optional.of(siri);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    inProgressFile.renameTo(SiriFileLoader.newFile(file, SUFFIX_FAILED));
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            ((InputStream)is).close();
            return optional;
        }
        return Optional.empty();
    }

    private static boolean matchFilename(File file) {
        return file.getName().endsWith(".xml");
    }

    private static File newFile(File originalFile, String suffix) {
        return new File(originalFile.getParentFile(), originalFile.getName() + suffix);
    }
}

