/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.spi;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import net.logstash.logback.argument.StructuredArguments;
import org.opentripplanner.updater.spi.UpdateError;
import org.opentripplanner.updater.spi.UpdateResult;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultLogger {
    private static final Logger LOG = LoggerFactory.getLogger(ResultLogger.class);

    public static void logUpdateResult(String feedId, String type, UpdateResult updateResult) {
        int totalUpdates = updateResult.successful() + updateResult.failed();
        if (totalUpdates > 0) {
            LOG.info("[feedId={}, type={}] {} of {} update messages were applied successfully (success rate: {}%)", new Object[]{feedId, type, updateResult.successful(), totalUpdates, DoubleUtils.roundTo2Decimals((double)((double)updateResult.successful() / (double)totalUpdates * 100.0))});
            ResultLogger.logUpdateResultErrors(feedId, type, updateResult);
        } else {
            LOG.info("[feedId={}, type={}] Feed did not contain any updates", (Object)feedId, (Object)type);
        }
    }

    public static void logUpdateResultErrors(String feedId, String type, UpdateResult updateResult) {
        if (updateResult.failed() == 0) {
            return;
        }
        Multimap<UpdateError.UpdateErrorType, UpdateError> errorIndex = updateResult.failures();
        errorIndex.keySet().forEach(key -> {
            Collection value = errorIndex.get((Object)key);
            Set tripIds = value.stream().map(UpdateError::debugId).collect(Collectors.toSet());
            LOG.warn("[{} {}] {} failures of {}: {}", new Object[]{StructuredArguments.keyValue((String)"feedId", (Object)feedId), StructuredArguments.keyValue((String)"type", (Object)type), value.size(), StructuredArguments.keyValue((String)"errorType", (Object)key), tripIds});
        });
    }
}

