/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.spi;

import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.updater.GraphWriterRunnable;
import org.opentripplanner.updater.spi.GraphUpdater;
import org.opentripplanner.updater.spi.PollingGraphUpdaterParameters;
import org.opentripplanner.updater.spi.WriteToGraphCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PollingGraphUpdater
implements GraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(PollingGraphUpdater.class);
    private final String configRef;
    private final Duration pollingPeriod;
    protected boolean blockReadinessUntilInitialized;
    protected volatile boolean primed;
    private WriteToGraphCallback saveResultOnGraph;
    @Nullable
    private volatile Future<?> previousTask;

    protected PollingGraphUpdater(PollingGraphUpdaterParameters config) {
        this.pollingPeriod = config.frequency();
        this.configRef = config.configRef();
    }

    public Duration pollingPeriod() {
        return this.pollingPeriod;
    }

    @Override
    public final void run() {
        try {
            if (OTPFeature.WaitForGraphUpdateInPollingUpdaters.isOn()) {
                this.waitForPreviousTask();
            }
            this.runPolling();
            if (this.runOnlyOnce()) {
                LOG.info("As requested in configuration, updater {} has run only once and will now stop.", (Object)this.getClass().getSimpleName());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info("OTP is shutting down, polling updater {} was interrupted and is stopping.", (Object)this.getClass().getName());
        }
        catch (CancellationException e) {
            LOG.info("OTP is shutting down, the polling updater {} was interrupted", (Object)this, (Object)e);
        }
        catch (Exception e) {
            LOG.error("Error while running polling updater {}", (Object)this, (Object)e);
        }
        finally {
            this.primed = true;
        }
    }

    public boolean runOnlyOnce() {
        return this.pollingPeriod.toSeconds() <= 0L;
    }

    @Override
    public boolean isPrimed() {
        return this.primed;
    }

    @Override
    public String getConfigRef() {
        return this.configRef;
    }

    @Override
    public final void setup(WriteToGraphCallback writeToGraphCallback) {
        this.saveResultOnGraph = writeToGraphCallback;
    }

    protected abstract void runPolling() throws Exception;

    protected final void updateGraph(GraphWriterRunnable task) {
        this.previousTask = this.saveResultOnGraph.execute(task);
    }

    private void waitForPreviousTask() throws InterruptedException, ExecutionException {
        if (this.previousTask != null && !this.previousTask.isDone()) {
            LOG.info("Delaying polling until the previous task is complete");
            long startBlockingWait = System.currentTimeMillis();
            this.previousTask.get();
            LOG.info("Resuming polling after waiting an additional {}s", (Object)((System.currentTimeMillis() - startBlockingWait) / 1000L));
        }
    }
}

