/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.spi;

import com.beust.jcommander.internal.Nullable;
import org.opentripplanner.framework.error.OtpError;
import org.opentripplanner.transit.model.framework.DataValidationException;
import org.opentripplanner.transit.model.framework.Result;
import org.opentripplanner.transit.model.timetable.TimetableValidationError;
import org.opentripplanner.updater.spi.UpdateError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataValidationExceptionMapper {
    private static final Logger LOG = LoggerFactory.getLogger(DataValidationExceptionMapper.class);

    public static <T> Result<T, UpdateError> toResult(DataValidationException error) {
        return DataValidationExceptionMapper.toResult(error, null);
    }

    public static <T> Result<T, UpdateError> toResult(DataValidationException error, @Nullable String producer) {
        OtpError otpError = error.error();
        if (otpError instanceof TimetableValidationError) {
            TimetableValidationError tt = (TimetableValidationError)otpError;
            return Result.failure(new UpdateError(tt.trip().getId(), DataValidationExceptionMapper.mapTimeTableError(tt.code()), tt.stopIndex(), producer));
        }
        LOG.error("Unhandled error: {}", (Object)error.getMessage(), (Object)error);
        return Result.failure(UpdateError.noTripId(UpdateError.UpdateErrorType.UNKNOWN));
    }

    private static <T> UpdateError.UpdateErrorType mapTimeTableError(TimetableValidationError.ErrorCode code) {
        return switch (code) {
            default -> throw new MatchException(null, null);
            case TimetableValidationError.ErrorCode.NEGATIVE_DWELL_TIME -> UpdateError.UpdateErrorType.NEGATIVE_DWELL_TIME;
            case TimetableValidationError.ErrorCode.NEGATIVE_HOP_TIME -> UpdateError.UpdateErrorType.NEGATIVE_HOP_TIME;
            case TimetableValidationError.ErrorCode.MISSING_ARRIVAL_TIME -> UpdateError.UpdateErrorType.INVALID_ARRIVAL_TIME;
            case TimetableValidationError.ErrorCode.MISSING_DEPARTURE_TIME -> UpdateError.UpdateErrorType.INVALID_DEPARTURE_TIME;
        };
    }
}

