/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.configure;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.opentripplanner.ext.siri.updater.azure.SiriAzureETUpdaterParameters;
import org.opentripplanner.ext.siri.updater.azure.SiriAzureSXUpdaterParameters;
import org.opentripplanner.ext.siri.updater.azure.SiriAzureUpdater;
import org.opentripplanner.ext.vehiclerentalservicedirectory.VehicleRentalServiceDirectoryFetcher;
import org.opentripplanner.ext.vehiclerentalservicedirectory.api.VehicleRentalServiceDirectoryFetcherParameters;
import org.opentripplanner.framework.io.OtpHttpClientFactory;
import org.opentripplanner.model.TimetableSnapshot;
import org.opentripplanner.model.calendar.openinghours.OpeningHoursCalendarService;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.service.realtimevehicles.RealtimeVehicleRepository;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.vehiclerental.VehicleRentalRepository;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.updater.DefaultRealTimeUpdateContext;
import org.opentripplanner.updater.GraphUpdaterManager;
import org.opentripplanner.updater.UpdatersParameters;
import org.opentripplanner.updater.alert.gtfs.GtfsRealtimeAlertsUpdater;
import org.opentripplanner.updater.alert.gtfs.GtfsRealtimeAlertsUpdaterParameters;
import org.opentripplanner.updater.alert.siri.SiriSXUpdaterParameters;
import org.opentripplanner.updater.alert.siri.lite.SiriSXLiteUpdaterParameters;
import org.opentripplanner.updater.configure.SiriUpdaterModule;
import org.opentripplanner.updater.spi.DataSource;
import org.opentripplanner.updater.spi.GraphUpdater;
import org.opentripplanner.updater.spi.TimetableSnapshotFlush;
import org.opentripplanner.updater.trip.TimetableSnapshotManager;
import org.opentripplanner.updater.trip.gtfs.GtfsRealTimeTripUpdateAdapter;
import org.opentripplanner.updater.trip.gtfs.updater.http.PollingTripUpdater;
import org.opentripplanner.updater.trip.gtfs.updater.http.PollingTripUpdaterParameters;
import org.opentripplanner.updater.trip.gtfs.updater.mqtt.MqttGtfsRealtimeUpdater;
import org.opentripplanner.updater.trip.gtfs.updater.mqtt.MqttGtfsRealtimeUpdaterParameters;
import org.opentripplanner.updater.trip.siri.SiriRealTimeTripUpdateAdapter;
import org.opentripplanner.updater.trip.siri.updater.SiriETUpdaterParameters;
import org.opentripplanner.updater.trip.siri.updater.google.SiriETGooglePubsubUpdater;
import org.opentripplanner.updater.trip.siri.updater.google.SiriETGooglePubsubUpdaterParameters;
import org.opentripplanner.updater.trip.siri.updater.lite.SiriETLiteUpdaterParameters;
import org.opentripplanner.updater.vehicle_parking.AvailabilityDataSourceFactory;
import org.opentripplanner.updater.vehicle_parking.VehicleParkingAvailabilityUpdater;
import org.opentripplanner.updater.vehicle_parking.VehicleParkingDataSourceFactory;
import org.opentripplanner.updater.vehicle_parking.VehicleParkingUpdater;
import org.opentripplanner.updater.vehicle_parking.VehicleParkingUpdaterParameters;
import org.opentripplanner.updater.vehicle_position.PollingVehiclePositionUpdater;
import org.opentripplanner.updater.vehicle_position.VehiclePositionsUpdaterParameters;
import org.opentripplanner.updater.vehicle_rental.VehicleRentalUpdater;
import org.opentripplanner.updater.vehicle_rental.VehicleRentalUpdaterParameters;
import org.opentripplanner.updater.vehicle_rental.datasources.VehicleRentalDataSource;
import org.opentripplanner.updater.vehicle_rental.datasources.VehicleRentalDataSourceFactory;

public class UpdaterConfigurator {
    private final Graph graph;
    private final VertexLinker linker;
    private final TimetableRepository timetableRepository;
    private final UpdatersParameters updatersParameters;
    private final RealtimeVehicleRepository realtimeVehicleRepository;
    private final VehicleRentalRepository vehicleRentalRepository;
    private final VehicleParkingRepository parkingRepository;
    private final TimetableSnapshotManager snapshotManager;

    private UpdaterConfigurator(Graph graph, VertexLinker linker, RealtimeVehicleRepository realtimeVehicleRepository, VehicleRentalRepository vehicleRentalRepository, VehicleParkingRepository parkingRepository, TimetableRepository timetableRepository, TimetableSnapshotManager snapshotManager, UpdatersParameters updatersParameters) {
        this.graph = graph;
        this.linker = linker;
        this.realtimeVehicleRepository = realtimeVehicleRepository;
        this.vehicleRentalRepository = vehicleRentalRepository;
        this.timetableRepository = timetableRepository;
        this.updatersParameters = updatersParameters;
        this.parkingRepository = parkingRepository;
        this.snapshotManager = snapshotManager;
    }

    public static void configure(Graph graph, VertexLinker linker, RealtimeVehicleRepository realtimeVehicleRepository, VehicleRentalRepository vehicleRentalRepository, VehicleParkingRepository parkingRepository, TimetableRepository timetableRepository, TimetableSnapshotManager snapshotManager, UpdatersParameters updatersParameters) {
        new UpdaterConfigurator(graph, linker, realtimeVehicleRepository, vehicleRentalRepository, parkingRepository, timetableRepository, snapshotManager, updatersParameters).configure();
    }

    private void configure() {
        ArrayList<GraphUpdater> updaters = new ArrayList<GraphUpdater>();
        updaters.addAll(this.createUpdatersFromConfig());
        updaters.addAll(this.fetchVehicleRentalServicesFromOnlineDirectory(this.updatersParameters.getVehicleRentalServiceDirectoryFetcherParameters()));
        TimetableSnapshot timetableSnapshotBuffer = this.snapshotManager.getTimetableSnapshotBuffer();
        GraphUpdaterManager updaterManager = new GraphUpdaterManager(new DefaultRealTimeUpdateContext(this.graph, this.timetableRepository, timetableSnapshotBuffer), updaters);
        this.configureTimetableSnapshotFlush(updaterManager, this.snapshotManager);
        updaterManager.startUpdaters();
        if (updaterManager.numberOfUpdaters() == 0) {
            updaterManager.stop();
        } else {
            this.timetableRepository.setUpdaterManager(updaterManager);
        }
    }

    public static void shutdownGraph(TimetableRepository timetableRepository) {
        GraphUpdaterManager updaterManager = timetableRepository.getUpdaterManager();
        if (updaterManager != null) {
            updaterManager.stop();
        }
    }

    private List<GraphUpdater> fetchVehicleRentalServicesFromOnlineDirectory(VehicleRentalServiceDirectoryFetcherParameters parameters) {
        if (parameters == null) {
            return List.of();
        }
        return VehicleRentalServiceDirectoryFetcher.createUpdatersFromEndpoint(parameters, this.linker, this.vehicleRentalRepository);
    }

    private List<GraphUpdater> createUpdatersFromConfig() {
        OpeningHoursCalendarService openingHoursCalendarService = this.graph.getOpeningHoursCalendarService();
        ArrayList<GraphUpdater> updaters = new ArrayList<GraphUpdater>();
        if (!this.updatersParameters.getVehicleRentalParameters().isEmpty()) {
            int maxHttpConnections = this.updatersParameters.getVehicleRentalParameters().size();
            OtpHttpClientFactory otpHttpClientFactory = new OtpHttpClientFactory(maxHttpConnections);
            for (VehicleRentalUpdaterParameters configItem : this.updatersParameters.getVehicleRentalParameters()) {
                VehicleRentalDataSource source = VehicleRentalDataSourceFactory.create(configItem.sourceParameters(), otpHttpClientFactory);
                updaters.add(new VehicleRentalUpdater(configItem, source, this.linker, this.vehicleRentalRepository));
            }
        }
        for (GtfsRealtimeAlertsUpdaterParameters gtfsRealtimeAlertsUpdaterParameters : this.updatersParameters.getGtfsRealtimeAlertsUpdaterParameters()) {
            updaters.add(new GtfsRealtimeAlertsUpdater(gtfsRealtimeAlertsUpdaterParameters, this.timetableRepository));
        }
        for (PollingTripUpdaterParameters pollingTripUpdaterParameters : this.updatersParameters.getPollingStoptimeUpdaterParameters()) {
            updaters.add(new PollingTripUpdater(pollingTripUpdaterParameters, this.provideGtfsAdapter()));
        }
        for (VehiclePositionsUpdaterParameters vehiclePositionsUpdaterParameters : this.updatersParameters.getVehiclePositionsUpdaterParameters()) {
            updaters.add(new PollingVehiclePositionUpdater(vehiclePositionsUpdaterParameters, this.realtimeVehicleRepository));
        }
        for (SiriETUpdaterParameters siriETUpdaterParameters : this.updatersParameters.getSiriETUpdaterParameters()) {
            updaters.add(SiriUpdaterModule.createSiriETUpdater(siriETUpdaterParameters, this.provideSiriAdapter()));
        }
        for (SiriETLiteUpdaterParameters siriETLiteUpdaterParameters : this.updatersParameters.getSiriETLiteUpdaterParameters()) {
            updaters.add(SiriUpdaterModule.createSiriETUpdater(siriETLiteUpdaterParameters, this.provideSiriAdapter()));
        }
        for (SiriETGooglePubsubUpdaterParameters siriETGooglePubsubUpdaterParameters : this.updatersParameters.getSiriETGooglePubsubUpdaterParameters()) {
            updaters.add(new SiriETGooglePubsubUpdater(siriETGooglePubsubUpdaterParameters, this.provideSiriAdapter()));
        }
        for (SiriSXUpdaterParameters siriSXUpdaterParameters : this.updatersParameters.getSiriSXUpdaterParameters()) {
            updaters.add(SiriUpdaterModule.createSiriSXUpdater(siriSXUpdaterParameters, this.timetableRepository));
        }
        for (SiriSXLiteUpdaterParameters siriSXLiteUpdaterParameters : this.updatersParameters.getSiriSXLiteUpdaterParameters()) {
            updaters.add(SiriUpdaterModule.createSiriSXUpdater(siriSXLiteUpdaterParameters, this.timetableRepository));
        }
        for (MqttGtfsRealtimeUpdaterParameters mqttGtfsRealtimeUpdaterParameters : this.updatersParameters.getMqttGtfsRealtimeUpdaterParameters()) {
            updaters.add(new MqttGtfsRealtimeUpdater(mqttGtfsRealtimeUpdaterParameters, this.provideGtfsAdapter()));
        }
        for (VehicleParkingUpdaterParameters vehicleParkingUpdaterParameters : this.updatersParameters.getVehicleParkingUpdaterParameters()) {
            switch (vehicleParkingUpdaterParameters.updateType()) {
                case FULL: {
                    DataSource<Object> source = VehicleParkingDataSourceFactory.create(vehicleParkingUpdaterParameters, openingHoursCalendarService);
                    updaters.add(new VehicleParkingUpdater(vehicleParkingUpdaterParameters, source, this.linker, this.parkingRepository));
                    break;
                }
                case AVAILABILITY_ONLY: {
                    DataSource<Object> source = AvailabilityDataSourceFactory.create(vehicleParkingUpdaterParameters);
                    updaters.add(new VehicleParkingAvailabilityUpdater(vehicleParkingUpdaterParameters, source, this.parkingRepository));
                }
            }
        }
        for (SiriAzureETUpdaterParameters siriAzureETUpdaterParameters : this.updatersParameters.getSiriAzureETUpdaterParameters()) {
            updaters.add(SiriAzureUpdater.createETUpdater(siriAzureETUpdaterParameters, this.provideSiriAdapter()));
        }
        for (SiriAzureSXUpdaterParameters siriAzureSXUpdaterParameters : this.updatersParameters.getSiriAzureSXUpdaterParameters()) {
            updaters.add(SiriAzureUpdater.createSXUpdater(siriAzureSXUpdaterParameters, this.timetableRepository));
        }
        return updaters;
    }

    private SiriRealTimeTripUpdateAdapter provideSiriAdapter() {
        return new SiriRealTimeTripUpdateAdapter(this.timetableRepository, this.snapshotManager);
    }

    private GtfsRealTimeTripUpdateAdapter provideGtfsAdapter() {
        return new GtfsRealTimeTripUpdateAdapter(this.timetableRepository, this.snapshotManager, () -> LocalDate.now(this.timetableRepository.getTimeZone()));
    }

    private void configureTimetableSnapshotFlush(GraphUpdaterManager updaterManager, TimetableSnapshotManager snapshotManager) {
        updaterManager.getScheduler().scheduleWithFixedDelay(new TimetableSnapshotFlush(snapshotManager), 0L, this.updatersParameters.timetableSnapshotParameters().maxSnapshotFrequency().toSeconds(), TimeUnit.SECONDS);
    }
}

