/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.configure;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.updater.alert.siri.SiriSXUpdater;
import org.opentripplanner.updater.alert.siri.SiriSXUpdaterParameters;
import org.opentripplanner.updater.alert.siri.lite.SiriLiteHttpLoader;
import org.opentripplanner.updater.alert.siri.lite.SiriSXLiteUpdaterParameters;
import org.opentripplanner.updater.spi.UpdateResult;
import org.opentripplanner.updater.support.siri.SiriFileLoader;
import org.opentripplanner.updater.support.siri.SiriHttpLoader;
import org.opentripplanner.updater.support.siri.SiriLoader;
import org.opentripplanner.updater.trip.metrics.TripUpdateMetrics;
import org.opentripplanner.updater.trip.siri.SiriRealTimeTripUpdateAdapter;
import org.opentripplanner.updater.trip.siri.updater.EstimatedTimetableSource;
import org.opentripplanner.updater.trip.siri.updater.SiriETHttpTripUpdateSource;
import org.opentripplanner.updater.trip.siri.updater.SiriETUpdater;
import org.opentripplanner.updater.trip.siri.updater.SiriETUpdaterParameters;
import org.opentripplanner.updater.trip.siri.updater.lite.SiriETLiteHttpTripUpdateSource;
import org.opentripplanner.updater.trip.siri.updater.lite.SiriETLiteUpdaterParameters;

public class SiriUpdaterModule {
    public static SiriETUpdater createSiriETUpdater(SiriETUpdater.Parameters params, SiriRealTimeTripUpdateAdapter adapter) {
        return new SiriETUpdater(params, adapter, SiriUpdaterModule.createSource(params), SiriUpdaterModule.createMetricsConsumer(params));
    }

    public static SiriSXUpdater createSiriSXUpdater(SiriSXUpdater.Parameters params, TimetableRepository timetableRepository) {
        return new SiriSXUpdater(params, timetableRepository, SiriUpdaterModule.createLoader(params));
    }

    private static EstimatedTimetableSource createSource(SiriETUpdater.Parameters params) {
        SiriETUpdater.Parameters parameters = params;
        Objects.requireNonNull(parameters);
        SiriETUpdater.Parameters parameters2 = parameters;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SiriETUpdaterParameters.class, SiriETLiteUpdaterParameters.class}, (Object)parameters2, n)) {
            case 0 -> {
                SiriETUpdaterParameters p = (SiriETUpdaterParameters)parameters2;
                yield new SiriETHttpTripUpdateSource(p.sourceParameters(), SiriUpdaterModule.createLoader(params));
            }
            case 1 -> {
                SiriETLiteUpdaterParameters p = (SiriETLiteUpdaterParameters)parameters2;
                yield new SiriETLiteHttpTripUpdateSource(p.sourceParameters(), SiriUpdaterModule.createLoader(params));
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(params));
        };
    }

    private static SiriLoader createLoader(SiriSXUpdater.Parameters params) {
        if (SiriFileLoader.matchesUrl(params.url())) {
            return new SiriFileLoader(params.url());
        }
        SiriSXUpdater.Parameters parameters = params;
        Objects.requireNonNull(parameters);
        SiriSXUpdater.Parameters parameters2 = parameters;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SiriSXUpdaterParameters.class, SiriSXLiteUpdaterParameters.class}, (Object)parameters2, n)) {
            case 0 -> {
                SiriSXUpdaterParameters p = (SiriSXUpdaterParameters)parameters2;
                yield new SiriHttpLoader(p.url(), p.timeout(), p.requestHeaders());
            }
            case 1 -> {
                SiriSXLiteUpdaterParameters p = (SiriSXLiteUpdaterParameters)parameters2;
                yield new SiriLiteHttpLoader(p.uri(), p.timeout(), p.requestHeaders());
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(params));
        };
    }

    private static SiriLoader createLoader(SiriETUpdater.Parameters params) {
        if (SiriFileLoader.matchesUrl(params.url())) {
            return new SiriFileLoader(params.url());
        }
        SiriETUpdater.Parameters parameters = params;
        Objects.requireNonNull(parameters);
        SiriETUpdater.Parameters parameters2 = parameters;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SiriETUpdaterParameters.class, SiriETLiteUpdaterParameters.class}, (Object)parameters2, n)) {
            case 0 -> {
                SiriETUpdaterParameters p = (SiriETUpdaterParameters)parameters2;
                yield new SiriHttpLoader(p.url(), p.timeout(), p.httpRequestHeaders(), p.previewInterval());
            }
            case 1 -> {
                SiriETLiteUpdaterParameters p = (SiriETLiteUpdaterParameters)parameters2;
                yield new SiriLiteHttpLoader(p.uri(), p.timeout(), p.httpRequestHeaders());
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(params));
        };
    }

    private static Consumer<UpdateResult> createMetricsConsumer(SiriETUpdater.Parameters params) {
        SiriETUpdater.Parameters parameters = params;
        Objects.requireNonNull(parameters);
        SiriETUpdater.Parameters parameters2 = parameters;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SiriETUpdaterParameters.class, SiriETLiteUpdaterParameters.class}, (Object)parameters2, n)) {
            case 0 -> {
                SiriETUpdaterParameters p = (SiriETUpdaterParameters)parameters2;
                yield TripUpdateMetrics.streaming(p);
            }
            case 1 -> {
                SiriETLiteUpdaterParameters p = (SiriETLiteUpdaterParameters)parameters2;
                yield TripUpdateMetrics.batch(p);
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(params));
        };
    }
}

