/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.alert.siri.mapping;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.StopCondition;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.updater.trip.siri.EntityResolver;
import org.opentripplanner.updater.trip.siri.SiriFuzzyTripMatcher;
import uk.org.ifopt.siri21.StopPlaceRef;
import uk.org.siri.siri21.AffectedLineStructure;
import uk.org.siri.siri21.AffectedOperatorStructure;
import uk.org.siri.siri21.AffectedRouteStructure;
import uk.org.siri.siri21.AffectedStopPlaceStructure;
import uk.org.siri.siri21.AffectedStopPointStructure;
import uk.org.siri.siri21.AffectedVehicleJourneyStructure;
import uk.org.siri.siri21.AffectsScopeStructure;
import uk.org.siri.siri21.DatedVehicleJourneyRef;
import uk.org.siri.siri21.FramedVehicleJourneyRefStructure;
import uk.org.siri.siri21.LineRef;
import uk.org.siri.siri21.NetworkRefStructure;
import uk.org.siri.siri21.OperatorRefStructure;
import uk.org.siri.siri21.RoutePointTypeEnumeration;
import uk.org.siri.siri21.StopPointRefStructure;
import uk.org.siri.siri21.VehicleJourneyRef;

public class AffectsMapper {
    private final String feedId;
    private final SiriFuzzyTripMatcher siriFuzzyTripMatcher;
    private final TransitService transitService;
    private final EntityResolver entityResolver;

    public AffectsMapper(String feedId, SiriFuzzyTripMatcher siriFuzzyTripMatcher, TransitService transitService) {
        this.feedId = feedId;
        this.siriFuzzyTripMatcher = siriFuzzyTripMatcher;
        this.transitService = transitService;
        this.entityResolver = new EntityResolver(transitService, feedId);
    }

    public List<EntitySelector> mapAffects(AffectsScopeStructure affectsStructure) {
        if (affectsStructure == null) {
            return List.of();
        }
        ArrayList<EntitySelector> selectors = new ArrayList<EntitySelector>();
        selectors.addAll(this.mapOperators(affectsStructure.getOperators()));
        selectors.addAll(this.mapStopPoints(affectsStructure.getStopPoints()));
        selectors.addAll(this.mapStopPlaces(affectsStructure.getStopPlaces()));
        selectors.addAll(this.mapNetworks(affectsStructure.getNetworks()));
        selectors.addAll(this.mapVehicleJourneys(affectsStructure.getVehicleJourneys()));
        return selectors;
    }

    private List<EntitySelector> mapVehicleJourneys(AffectsScopeStructure.VehicleJourneys vjs) {
        if (vjs == null || AffectsMapper.isEmpty(vjs.getAffectedVehicleJourneies())) {
            return List.of();
        }
        ArrayList<EntitySelector> selectors = new ArrayList<EntitySelector>();
        for (AffectedVehicleJourneyStructure affectedVehicleJourney : vjs.getAffectedVehicleJourneies()) {
            List datedVehicleJourneyReves;
            FramedVehicleJourneyRefStructure framedVehicleJourneyRef;
            List vehicleJourneyReves;
            ArrayList<AffectedStopPointStructure> affectedStops = new ArrayList<AffectedStopPointStructure>();
            List routes = affectedVehicleJourney.getRoutes();
            if (routes != null) {
                for (AffectedRouteStructure route : routes) {
                    if (route.getStopPoints() == null) continue;
                    List stopPointsList = route.getStopPoints().getAffectedStopPointsAndLinkProjectionToNextStopPoints();
                    Iterator iterator = stopPointsList.iterator();
                    while (iterator.hasNext()) {
                        Serializable serializable = (Serializable)iterator.next();
                        if (!(serializable instanceof AffectedStopPointStructure)) continue;
                        AffectedStopPointStructure stopPointStructure = (AffectedStopPointStructure)serializable;
                        affectedStops.add(stopPointStructure);
                    }
                }
            }
            if (AffectsMapper.isNotEmpty(vehicleJourneyReves = affectedVehicleJourney.getVehicleJourneyReves())) {
                ArrayList<FeedScopedId> affectedTripIds = new ArrayList<FeedScopedId>();
                for (VehicleJourneyRef vehicleJourneyRef : vehicleJourneyReves) {
                    ArrayList<FeedScopedId> tripIds = new ArrayList<FeedScopedId>();
                    Trip trip = this.entityResolver.resolveTrip(vehicleJourneyRef.getValue());
                    if (trip != null) {
                        tripIds.add(trip.getId());
                    } else if (this.siriFuzzyTripMatcher != null) {
                        tripIds.addAll(this.siriFuzzyTripMatcher.getTripIdForInternalPlanningCodeServiceDate(vehicleJourneyRef.getValue(), this.entityResolver.resolveServiceDate(affectedVehicleJourney.getOriginAimedDepartureTime())));
                    }
                    if (tripIds.isEmpty()) {
                        tripIds.add(this.entityResolver.resolveId(vehicleJourneyRef.getValue()));
                    }
                    affectedTripIds.addAll(tripIds);
                }
                selectors.addAll(this.mapTripSelectors(affectedStops, affectedTripIds, this.entityResolver.resolveServiceDate(affectedVehicleJourney.getOriginAimedDepartureTime())));
            }
            if ((framedVehicleJourneyRef = affectedVehicleJourney.getFramedVehicleJourneyRef()) != null) {
                selectors.addAll(this.mapTripSelectors(affectedStops, List.of(this.entityResolver.resolveId(framedVehicleJourneyRef.getDatedVehicleJourneyRef())), this.entityResolver.resolveServiceDate(framedVehicleJourneyRef)));
            }
            if (!AffectsMapper.isNotEmpty(datedVehicleJourneyReves = affectedVehicleJourney.getDatedVehicleJourneyReves())) continue;
            for (DatedVehicleJourneyRef datedVehicleJourneyRef : datedVehicleJourneyReves) {
                TripOnServiceDate tripOnServiceDate = this.entityResolver.resolveTripOnServiceDate(datedVehicleJourneyRef.getValue());
                if (tripOnServiceDate != null) {
                    selectors.addAll(this.mapTripSelectors(affectedStops, List.of(tripOnServiceDate.getTrip().getId()), tripOnServiceDate.getServiceDate()));
                    continue;
                }
                selectors.addAll(this.mapTripSelectors(affectedStops, List.of(this.entityResolver.resolveId(datedVehicleJourneyRef.getValue())), this.entityResolver.resolveServiceDate(affectedVehicleJourney.getOriginAimedDepartureTime())));
            }
        }
        return selectors;
    }

    private List<EntitySelector> mapTripSelectors(List<AffectedStopPointStructure> affectedStops, List<FeedScopedId> tripIds, LocalDate serviceDate) {
        ArrayList<EntitySelector> selectors = new ArrayList<EntitySelector>();
        for (FeedScopedId tripId : tripIds) {
            if (!affectedStops.isEmpty()) {
                for (AffectedStopPointStructure affectedStop : affectedStops) {
                    FeedScopedId stop = AffectsMapper.getStop(affectedStop.getStopPointRef().getValue(), this.feedId, this.transitService);
                    if (stop == null) {
                        stop = new FeedScopedId(this.feedId, affectedStop.getStopPointRef().getValue());
                    }
                    EntitySelector.StopAndTrip entitySelector = new EntitySelector.StopAndTrip(stop, tripId, serviceDate, AffectsMapper.resolveStopConditions(affectedStop.getStopConditions()));
                    selectors.add(entitySelector);
                }
                continue;
            }
            selectors.add(new EntitySelector.Trip(tripId, serviceDate));
        }
        return selectors;
    }

    private List<EntitySelector> mapNetworks(AffectsScopeStructure.Networks networks) {
        if (networks == null || AffectsMapper.isEmpty(networks.getAffectedNetworks())) {
            return List.of();
        }
        ArrayList<EntitySelector> selectors = new ArrayList<EntitySelector>();
        for (AffectsScopeStructure.Networks.AffectedNetwork affectedNetwork : networks.getAffectedNetworks()) {
            List affectedLines = affectedNetwork.getAffectedLines();
            if (AffectsMapper.isNotEmpty(affectedLines)) {
                for (AffectedLineStructure line : affectedLines) {
                    LineRef lineRef = line.getLineRef();
                    if (lineRef == null || lineRef.getValue() == null) continue;
                    ArrayList<AffectedStopPointStructure> affectedStops = new ArrayList<AffectedStopPointStructure>();
                    AffectedLineStructure.Routes routes = line.getRoutes();
                    if (routes != null) {
                        for (AffectedRouteStructure route : routes.getAffectedRoutes()) {
                            if (route.getStopPoints() == null) continue;
                            List stopPointsList = route.getStopPoints().getAffectedStopPointsAndLinkProjectionToNextStopPoints();
                            for (Serializable serializable : stopPointsList) {
                                if (!(serializable instanceof AffectedStopPointStructure)) continue;
                                AffectedStopPointStructure stopPointStructure = (AffectedStopPointStructure)serializable;
                                affectedStops.add(stopPointStructure);
                            }
                        }
                    }
                    FeedScopedId affectedRoute = new FeedScopedId(this.feedId, lineRef.getValue());
                    if (!affectedStops.isEmpty()) {
                        for (AffectedStopPointStructure affectedStop : affectedStops) {
                            FeedScopedId stop = AffectsMapper.getStop(affectedStop.getStopPointRef().getValue(), this.feedId, this.transitService);
                            if (stop == null) {
                                stop = new FeedScopedId(this.feedId, affectedStop.getStopPointRef().getValue());
                            }
                            EntitySelector.StopAndRoute entitySelector = new EntitySelector.StopAndRoute(stop, AffectsMapper.resolveStopConditions(affectedStop.getStopConditions()), affectedRoute);
                            selectors.add(entitySelector);
                        }
                        continue;
                    }
                    selectors.add(new EntitySelector.Route(affectedRoute));
                }
                continue;
            }
            NetworkRefStructure networkRef = affectedNetwork.getNetworkRef();
            if (networkRef == null || networkRef.getValue() == null) continue;
            String networkId = networkRef.getValue();
            selectors.add(new EntitySelector.Unknown("Alert affects network %s".formatted(networkId)));
        }
        return selectors;
    }

    private List<EntitySelector> mapStopPoints(AffectsScopeStructure.StopPoints stopPoints) {
        if (stopPoints == null || AffectsMapper.isEmpty(stopPoints.getAffectedStopPoints())) {
            return List.of();
        }
        ArrayList<EntitySelector> selectors = new ArrayList<EntitySelector>();
        for (AffectedStopPointStructure stopPoint : stopPoints.getAffectedStopPoints()) {
            StopPointRefStructure stopPointRef = stopPoint.getStopPointRef();
            if (stopPointRef == null || stopPointRef.getValue() == null) continue;
            FeedScopedId stopId = AffectsMapper.getStop(stopPointRef.getValue(), this.feedId, this.transitService);
            if (stopId == null) {
                stopId = new FeedScopedId(this.feedId, stopPointRef.getValue());
            }
            EntitySelector.Stop entitySelector = new EntitySelector.Stop(stopId, AffectsMapper.resolveStopConditions(stopPoint.getStopConditions()));
            selectors.add(entitySelector);
        }
        return selectors;
    }

    private List<EntitySelector> mapStopPlaces(AffectsScopeStructure.StopPlaces stopPlaces) {
        if (stopPlaces == null || AffectsMapper.isEmpty(stopPlaces.getAffectedStopPlaces())) {
            return List.of();
        }
        ArrayList<EntitySelector> selectors = new ArrayList<EntitySelector>();
        for (AffectedStopPlaceStructure stopPlace : stopPlaces.getAffectedStopPlaces()) {
            StopPlaceRef stopPlaceRef = stopPlace.getStopPlaceRef();
            if (stopPlaceRef == null || stopPlaceRef.getValue() == null) continue;
            FeedScopedId stopId = AffectsMapper.getStop(stopPlaceRef.getValue(), this.feedId, this.transitService);
            if (stopId == null) {
                stopId = new FeedScopedId(this.feedId, stopPlaceRef.getValue());
            }
            selectors.add(new EntitySelector.Stop(stopId));
        }
        return selectors;
    }

    private List<EntitySelector> mapOperators(AffectsScopeStructure.Operators operators) {
        if (operators == null || AffectsMapper.isEmpty(operators.getAffectedOperators())) {
            return List.of();
        }
        ArrayList<EntitySelector> selectors = new ArrayList<EntitySelector>();
        for (AffectedOperatorStructure affectedOperator : operators.getAffectedOperators()) {
            OperatorRefStructure operatorRef = affectedOperator.getOperatorRef();
            if (operatorRef == null || operatorRef.getValue() == null) continue;
            String agencyId = operatorRef.getValue();
            selectors.add(new EntitySelector.Agency(new FeedScopedId(this.feedId, agencyId)));
        }
        return selectors;
    }

    private static FeedScopedId getStop(String siriStopId, String feedId, TransitService transitService) {
        FeedScopedId id = new FeedScopedId(feedId, siriStopId);
        if (transitService.getRegularStop(id) != null) {
            return id;
        }
        if (transitService.getStation(id) != null) {
            return id;
        }
        return null;
    }

    private static Set<StopCondition> resolveStopConditions(List<RoutePointTypeEnumeration> stopConditions) {
        HashSet<StopCondition> alertStopConditions = new HashSet<StopCondition>();
        if (stopConditions != null) {
            for (RoutePointTypeEnumeration stopCondition : stopConditions) {
                switch (stopCondition) {
                    case EXCEPTIONAL_STOP: {
                        alertStopConditions.add(StopCondition.EXCEPTIONAL_STOP);
                        break;
                    }
                    case DESTINATION: {
                        alertStopConditions.add(StopCondition.DESTINATION);
                        break;
                    }
                    case NOT_STOPPING: {
                        alertStopConditions.add(StopCondition.NOT_STOPPING);
                        break;
                    }
                    case REQUEST_STOP: {
                        alertStopConditions.add(StopCondition.REQUEST_STOP);
                        break;
                    }
                    case START_POINT: {
                        alertStopConditions.add(StopCondition.START_POINT);
                    }
                }
            }
        }
        if (alertStopConditions.isEmpty()) {
            alertStopConditions.add(StopCondition.START_POINT);
            alertStopConditions.add(StopCondition.DESTINATION);
        }
        return alertStopConditions;
    }

    private static boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    private static boolean isNotEmpty(List<?> list) {
        return list != null && !list.isEmpty();
    }
}

