/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.alert.siri.lite;

import java.net.URI;
import java.time.Duration;
import java.util.Optional;
import org.opentripplanner.framework.io.OtpHttpClient;
import org.opentripplanner.framework.io.OtpHttpClientFactory;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.opentripplanner.updater.support.siri.SiriHelper;
import org.opentripplanner.updater.support.siri.SiriLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri21.Siri;

public class SiriLiteHttpLoader
implements SiriLoader {
    private static final Logger LOG = LoggerFactory.getLogger(SiriLiteHttpLoader.class);
    private final HttpHeaders headers;
    private final URI uri;
    private final Duration timeout;
    private final OtpHttpClient otpHttpClient;

    public SiriLiteHttpLoader(URI uri, Duration timeout, HttpHeaders headers) {
        this.uri = uri;
        this.timeout = timeout;
        this.headers = HttpHeaders.of().acceptApplicationXML().add(headers).build();
        this.otpHttpClient = new OtpHttpClientFactory(timeout, timeout).create(LOG);
    }

    @Override
    public Optional<Siri> fetchSXFeed(String ignored) {
        return this.fetchFeed();
    }

    @Override
    public Optional<Siri> fetchETFeed(String ignored) {
        return this.fetchFeed();
    }

    private Optional<Siri> fetchFeed() {
        return this.otpHttpClient.getAndMap(this.uri, this.timeout, this.headers.asMap(), is -> Optional.of(SiriHelper.unmarshal(is)));
    }
}

