/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.alert.siri;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import org.opentripplanner.framework.io.OtpHttpClientException;
import org.opentripplanner.framework.retry.OtpRetry;
import org.opentripplanner.framework.retry.OtpRetryBuilder;
import org.opentripplanner.routing.impl.TransitAlertServiceImpl;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.updater.alert.TransitAlertProvider;
import org.opentripplanner.updater.alert.siri.SiriAlertsUpdateHandler;
import org.opentripplanner.updater.spi.PollingGraphUpdater;
import org.opentripplanner.updater.spi.PollingGraphUpdaterParameters;
import org.opentripplanner.updater.support.siri.SiriLoader;
import org.opentripplanner.updater.trip.UrlUpdaterParameters;
import org.opentripplanner.utils.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri21.ServiceDelivery;
import uk.org.siri.siri21.Siri;

public class SiriSXUpdater
extends PollingGraphUpdater
implements TransitAlertProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SiriSXUpdater.class);
    private static final int RETRY_MAX_ATTEMPTS = 3;
    private static final Duration RETRY_INITIAL_DELAY = Duration.ofSeconds(5L);
    private static final int RETRY_BACKOFF = 2;
    private final String url;
    private final String originalRequestorRef;
    private final TransitAlertService transitAlertService;
    private final SiriAlertsUpdateHandler updateHandler;
    private ZonedDateTime lastTimestamp = ZonedDateTime.now().minusWeeks(1L);
    private String requestorRef;
    private int retryCount = 0;
    private final SiriLoader siriHttpLoader;
    private final OtpRetry retry;

    public SiriSXUpdater(Parameters config, TimetableRepository timetableRepository, SiriLoader siriLoader) {
        super(config);
        this.url = config.url();
        this.requestorRef = config.requestorRef();
        if (this.requestorRef == null || this.requestorRef.isEmpty()) {
            this.requestorRef = "otp-" + String.valueOf(UUID.randomUUID());
        }
        this.originalRequestorRef = this.requestorRef;
        this.blockReadinessUntilInitialized = config.blockReadinessUntilInitialized();
        this.transitAlertService = new TransitAlertServiceImpl(timetableRepository);
        this.updateHandler = new SiriAlertsUpdateHandler(config.feedId(), this.transitAlertService, config.earlyStart());
        this.siriHttpLoader = siriLoader;
        this.retry = new OtpRetryBuilder().withName("SIRI-SX Update").withMaxAttempts(3).withInitialRetryInterval(RETRY_INITIAL_DELAY).withBackoffMultiplier(2).withRetryableException(OtpHttpClientException.class::isInstance).withOnRetry(this::updateRequestorRef).build();
        LOG.info("Creating SIRI-SX updater running every {}: {}", (Object)this.pollingPeriod(), (Object)this.url);
    }

    @Override
    public TransitAlertService getTransitAlertService() {
        return this.transitAlertService;
    }

    @Override
    protected void runPolling() throws InterruptedException {
        this.retry.execute(this::updateSiri);
    }

    public String toString() {
        return ToStringBuilder.of(SiriSXUpdater.class).addStr("url", this.url).addDuration("frequency", this.pollingPeriod()).toString();
    }

    private void updateSiri() {
        boolean moreData = false;
        do {
            boolean markPrimed;
            Optional<Siri> updates;
            if (!(updates = this.getUpdates()).isPresent()) continue;
            ServiceDelivery serviceDelivery = updates.get().getServiceDelivery();
            moreData = Boolean.TRUE.equals(serviceDelivery.isMoreData());
            boolean bl = markPrimed = !moreData;
            if (serviceDelivery.getSituationExchangeDeliveries() == null) continue;
            this.updateGraph(context -> {
                this.updateHandler.update(serviceDelivery, context);
                if (markPrimed) {
                    this.primed = true;
                }
            });
        } while (moreData);
    }

    private Optional<Siri> getUpdates() {
        long t1 = System.currentTimeMillis();
        try {
            Optional<Siri> siri = this.siriHttpLoader.fetchSXFeed(this.requestorRef);
            if (siri.isEmpty()) {
                return Optional.empty();
            }
            ServiceDelivery serviceDelivery = siri.get().getServiceDelivery();
            if (serviceDelivery == null) {
                throw new RuntimeException("Failed to get serviceDelivery " + this.url);
            }
            ZonedDateTime responseTimestamp = serviceDelivery.getResponseTimestamp();
            if (responseTimestamp.isBefore(this.lastTimestamp)) {
                LOG.info("Ignoring feed with an old timestamp.");
                return Optional.empty();
            }
            this.lastTimestamp = responseTimestamp;
            return siri;
        }
        catch (OtpHttpClientException e) {
            LOG.info("Retryable exception while reading SIRI feed from {} after {} ms", (Object)this.url, (Object)(System.currentTimeMillis() - t1));
            throw e;
        }
        catch (Exception e) {
            LOG.error("Non-retryable exception while reading SIRI feed from {} after {} ms", (Object)this.url, (Object)(System.currentTimeMillis() - t1));
            return Optional.empty();
        }
    }

    private void updateRequestorRef() {
        ++this.retryCount;
        this.requestorRef = this.originalRequestorRef + "-retry-" + this.retryCount;
    }

    public static interface Parameters
    extends PollingGraphUpdaterParameters,
    UrlUpdaterParameters {
        public String requestorRef();

        public boolean blockReadinessUntilInitialized();

        public Duration earlyStart();
    }
}

