/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.alert.siri;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.framework.i18n.TranslatedString;
import org.opentripplanner.routing.alertpatch.AlertUrl;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TimePeriod;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.alertpatch.TransitAlertBuilder;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.updater.RealTimeUpdateContext;
import org.opentripplanner.updater.alert.siri.mapping.AffectsMapper;
import org.opentripplanner.updater.alert.siri.mapping.SiriSeverityMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri21.DefaultedTextStructure;
import uk.org.siri.siri21.HalfOpenTimestampOutputRangeStructure;
import uk.org.siri.siri21.InfoLinkStructure;
import uk.org.siri.siri21.NaturalLanguageStringStructure;
import uk.org.siri.siri21.PtSituationElement;
import uk.org.siri.siri21.ServiceDelivery;
import uk.org.siri.siri21.SituationExchangeDeliveryStructure;
import uk.org.siri.siri21.WorkflowStatusEnumeration;

public class SiriAlertsUpdateHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SiriAlertsUpdateHandler.class);
    private final String feedId;
    private final Set<TransitAlert> alerts = new HashSet<TransitAlert>();
    private final TransitAlertService transitAlertService;
    private final Duration earlyStart;

    public SiriAlertsUpdateHandler(String feedId, TransitAlertService transitAlertService, Duration earlyStart) {
        this.feedId = feedId;
        this.transitAlertService = transitAlertService;
        this.earlyStart = earlyStart;
    }

    public void update(ServiceDelivery delivery, RealTimeUpdateContext context) {
        for (SituationExchangeDeliveryStructure sxDelivery : delivery.getSituationExchangeDeliveries()) {
            SituationExchangeDeliveryStructure.Situations situations = sxDelivery.getSituations();
            if (situations == null) continue;
            long t1 = System.currentTimeMillis();
            int addedCounter = 0;
            int expiredCounter = 0;
            for (PtSituationElement sxElement : situations.getPtSituationElements()) {
                boolean expireSituation;
                boolean bl = expireSituation = sxElement.getProgress() != null && sxElement.getProgress().equals((Object)WorkflowStatusEnumeration.CLOSED);
                if (sxElement.getSituationNumber() == null) continue;
                String situationNumber = sxElement.getSituationNumber().getValue();
                FeedScopedId id = new FeedScopedId(this.feedId, situationNumber);
                if (expireSituation) {
                    this.alerts.removeIf(transitAlert -> transitAlert.getId().equals(id));
                    ++expiredCounter;
                    continue;
                }
                TransitAlert alert = null;
                try {
                    alert = this.mapSituationToAlert(sxElement, context);
                    ++addedCounter;
                }
                catch (Exception e) {
                    LOG.info("Caught exception when processing situation with situationNumber {}: {}", (Object)situationNumber, (Object)e);
                }
                if (alert == null) continue;
                this.alerts.removeIf(transitAlert -> transitAlert.getId().equals(id));
                this.alerts.add(alert);
            }
            this.transitAlertService.setAlerts(this.alerts);
            LOG.info("Added {} alerts, expired {} alerts based on {} situations, current alert-count: {}, elapsed time {}ms", new Object[]{addedCounter, expiredCounter, situations.getPtSituationElements().size(), this.transitAlertService.getAllAlerts().size(), System.currentTimeMillis() - t1});
        }
    }

    private TransitAlert mapSituationToAlert(PtSituationElement situation, RealTimeUpdateContext context) {
        TransitAlertBuilder alert = this.createAlertWithTexts(situation);
        if (I18NString.hasNoValue(alert.headerText()) && I18NString.hasNoValue(alert.descriptionText()) && I18NString.hasNoValue(alert.detailText())) {
            LOG.debug("Empty Alert - ignoring situationNumber: {}", situation.getSituationNumber() != null ? situation.getSituationNumber().getValue() : null);
            return null;
        }
        if (situation.getCreationTime() != null) {
            alert.withCreationTime(situation.getCreationTime());
        }
        if (situation.getVersionedAtTime() != null) {
            alert.withUpdatedTime(situation.getVersionedAtTime());
        }
        if (situation.getVersion() != null && situation.getVersion().getValue() != null) {
            alert.withVersion(situation.getVersion().getValue().intValue());
        }
        ArrayList<TimePeriod> periods = new ArrayList<TimePeriod>();
        if (situation.getValidityPeriods().size() > 0) {
            for (HalfOpenTimestampOutputRangeStructure activePeriod : situation.getValidityPeriods()) {
                long realStart = activePeriod.getStartTime() != null ? this.getEpochSecond(activePeriod.getStartTime()) : 0L;
                long start = activePeriod.getStartTime() != null ? realStart - this.earlyStart.toSeconds() : 0L;
                long realEnd = activePeriod.getEndTime() != null ? this.getEpochSecond(activePeriod.getEndTime()) : Long.MAX_VALUE;
                long end = activePeriod.getEndTime() != null ? realEnd : Long.MAX_VALUE;
                periods.add(new TimePeriod(start, end));
            }
        } else {
            periods.add(new TimePeriod(0L, Long.MAX_VALUE));
        }
        alert.addTimePeriods(periods);
        if (situation.getPriority() != null) {
            alert.withPriority(situation.getPriority().intValue());
        }
        alert.addEntites(new AffectsMapper(this.feedId, context.siriFuzzyTripMatcher(), context.transitService()).mapAffects(situation.getAffects()));
        if (alert.entities().isEmpty()) {
            LOG.info("No match found for Alert - setting Unknown entity for situation with situationNumber {}", (Object)alert.getId());
            alert.addEntity(new EntitySelector.Unknown("Alert had no entities that could be handled"));
        }
        if (situation.getReportType() != null) {
            alert.withType(situation.getReportType().value());
        }
        alert.withSeverity(SiriSeverityMapper.getAlertSeverityForSiriSeverity(situation.getSeverity()));
        if (situation.getParticipantRef() != null) {
            alert.withSiriCodespace(situation.getParticipantRef().getValue());
        }
        return (TransitAlert)alert.build();
    }

    private long getEpochSecond(ZonedDateTime startTime) {
        return startTime.toEpochSecond();
    }

    private TransitAlertBuilder createAlertWithTexts(PtSituationElement situation) {
        return TransitAlert.of(new FeedScopedId(this.feedId, situation.getSituationNumber().getValue())).withDescriptionText(this.mapTranslatedString(situation.getDescriptions())).withDetailText(this.mapTranslatedString(situation.getDetails())).withAdviceText(this.mapTranslatedString(situation.getAdvices())).withHeaderText(this.mapTranslatedString(situation.getSummaries())).withUrl(this.mapInfoLinkToI18NString(situation.getInfoLinks())).addSiriUrls(this.mapInfoLinks(situation));
    }

    private I18NString mapInfoLinkToI18NString(PtSituationElement.InfoLinks infoLinks) {
        InfoLinkStructure infoLinkStructure;
        if (infoLinks != null && this.isNotEmpty(infoLinks.getInfoLinks()) && (infoLinkStructure = (InfoLinkStructure)infoLinks.getInfoLinks().get(0)) != null && infoLinkStructure.getUri() != null) {
            return new NonLocalizedString(infoLinkStructure.getUri());
        }
        return null;
    }

    private List<AlertUrl> mapInfoLinks(PtSituationElement situation) {
        PtSituationElement.InfoLinks infoLinks = situation.getInfoLinks();
        ArrayList<AlertUrl> alertUrls = new ArrayList<AlertUrl>();
        if (infoLinks != null && this.isNotEmpty(infoLinks.getInfoLinks())) {
            for (InfoLinkStructure infoLink : infoLinks.getInfoLinks()) {
                String uri;
                String label = null;
                List labels = infoLink.getLabels();
                if (labels != null && !labels.isEmpty()) {
                    NaturalLanguageStringStructure lbl = (NaturalLanguageStringStructure)labels.get(0);
                    label = lbl.getValue();
                }
                if ((uri = infoLink.getUri()) != null) {
                    alertUrls.add(new AlertUrl(uri, label));
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("URI missing in info-link - ignoring info-link in situation: {}", situation.getSituationNumber() != null ? situation.getSituationNumber().getValue() : null);
            }
        }
        return alertUrls;
    }

    private boolean isNotEmpty(List<?> list) {
        return list != null && !list.isEmpty();
    }

    private I18NString mapTranslatedString(List<DefaultedTextStructure> input) {
        HashMap<String, String> translations = new HashMap<String, String>();
        if (input != null && input.size() > 0) {
            for (DefaultedTextStructure textStructure : input) {
                String language = "";
                String value = "";
                if (textStructure.getLang() != null) {
                    language = textStructure.getLang();
                }
                if (textStructure.getValue() != null) {
                    value = textStructure.getValue();
                }
                translations.put(language, value);
            }
        } else {
            translations.put("", "");
        }
        return translations.isEmpty() ? null : TranslatedString.getI18NString(translations, false, true);
    }
}

