/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.alert.gtfs;

import com.google.transit.realtime.GtfsRealtime;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import org.opentripplanner.framework.io.OtpHttpClient;
import org.opentripplanner.framework.io.OtpHttpClientFactory;
import org.opentripplanner.routing.impl.TransitAlertServiceImpl;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.updater.alert.TransitAlertProvider;
import org.opentripplanner.updater.alert.gtfs.AlertsUpdateHandler;
import org.opentripplanner.updater.alert.gtfs.GtfsRealtimeAlertsUpdaterParameters;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.opentripplanner.updater.spi.PollingGraphUpdater;
import org.opentripplanner.utils.tostring.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsRealtimeAlertsUpdater
extends PollingGraphUpdater
implements TransitAlertProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GtfsRealtimeAlertsUpdater.class);
    private final String url;
    private final AlertsUpdateHandler updateHandler;
    private final TransitAlertService transitAlertService;
    private final HttpHeaders headers;
    private final OtpHttpClient otpHttpClient;
    private Long lastTimestamp = Long.MIN_VALUE;

    public GtfsRealtimeAlertsUpdater(GtfsRealtimeAlertsUpdaterParameters config, TimetableRepository timetableRepository) {
        super(config);
        this.url = config.url();
        this.headers = HttpHeaders.of().acceptProtobuf().add(config.headers()).build();
        TransitAlertServiceImpl transitAlertService = new TransitAlertServiceImpl(timetableRepository);
        this.transitAlertService = transitAlertService;
        this.updateHandler = new AlertsUpdateHandler(config.fuzzyTripMatching());
        this.updateHandler.setEarlyStart(config.earlyStartSec());
        this.updateHandler.setFeedId(config.feedId());
        this.updateHandler.setTransitAlertService(transitAlertService);
        this.otpHttpClient = new OtpHttpClientFactory().create(LOG);
        LOG.info("Creating real-time alert updater running every {}: {}", (Object)this.pollingPeriod(), (Object)this.url);
    }

    @Override
    public TransitAlertService getTransitAlertService() {
        return this.transitAlertService;
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addStr("url", this.url).toString();
    }

    @Override
    protected void runPolling() throws InterruptedException, ExecutionException {
        GtfsRealtime.FeedMessage feed = this.otpHttpClient.getAndMap(URI.create(this.url), this.headers.asMap(), GtfsRealtime.FeedMessage::parseFrom);
        long feedTimestamp = feed.getHeader().getTimestamp();
        if (feedTimestamp == this.lastTimestamp) {
            LOG.debug("Ignoring feed with a timestamp that has not been updated from {}", (Object)this.url);
            return;
        }
        if (feedTimestamp < this.lastTimestamp) {
            LOG.info("Ignoring feed with older than previous timestamp from {}", (Object)this.url);
            return;
        }
        this.updateGraph(context -> this.updateHandler.update(feed, context.gtfsRealtimeFuzzyTripMatcher()));
        this.lastTimestamp = feedTimestamp;
    }
}

