/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opentripplanner.model.projectinfo.OtpProjectInfo;
import org.opentripplanner.updater.GraphUpdaterStatus;
import org.opentripplanner.updater.GraphWriterRunnable;
import org.opentripplanner.updater.RealTimeUpdateContext;
import org.opentripplanner.updater.spi.GraphUpdater;
import org.opentripplanner.updater.spi.PollingGraphUpdater;
import org.opentripplanner.updater.spi.WriteToGraphCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphUpdaterManager
implements WriteToGraphCallback,
GraphUpdaterStatus {
    private static final Logger LOG = LoggerFactory.getLogger(GraphUpdaterManager.class);
    private static final int MIN_POLLING_UPDATER_THREADS = 6;
    private final ScheduledExecutorService scheduler;
    private final ScheduledExecutorService pollingUpdaterPool;
    private final ExecutorService nonPollingUpdaterPool;
    private final List<GraphUpdater> updaterList = new ArrayList<GraphUpdater>();
    private final RealTimeUpdateContext realtimeUpdateContext;

    public GraphUpdaterManager(RealTimeUpdateContext context, List<GraphUpdater> updaters) {
        this.realtimeUpdateContext = context;
        ThreadFactory graphWriterThreadFactory = new ThreadFactoryBuilder().setNameFormat("graph-writer").build();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(graphWriterThreadFactory);
        ThreadFactory updaterThreadFactory = new ThreadFactoryBuilder().setNameFormat("updater-%d").build();
        this.pollingUpdaterPool = Executors.newScheduledThreadPool(Math.max(6, Runtime.getRuntime().availableProcessors()), updaterThreadFactory);
        this.nonPollingUpdaterPool = Executors.newCachedThreadPool(updaterThreadFactory);
        for (GraphUpdater updater : updaters) {
            this.updaterList.add(updater);
            updater.setup(this);
        }
    }

    public void startUpdaters() {
        for (GraphUpdater updater : this.updaterList) {
            Runnable runUpdater = () -> {
                try {
                    updater.run();
                }
                catch (Exception e) {
                    LOG.error("Error while running updater {}:", (Object)updater.getClass().getName(), (Object)e);
                }
            };
            if (updater instanceof PollingGraphUpdater) {
                PollingGraphUpdater pollingGraphUpdater = (PollingGraphUpdater)updater;
                LOG.info("Scheduling polling updater {}", (Object)updater);
                if (pollingGraphUpdater.runOnlyOnce()) {
                    this.pollingUpdaterPool.schedule(runUpdater, 0L, TimeUnit.SECONDS);
                    continue;
                }
                this.pollingUpdaterPool.scheduleWithFixedDelay(runUpdater, 0L, pollingGraphUpdater.pollingPeriod().toSeconds(), TimeUnit.SECONDS);
                continue;
            }
            LOG.info("Starting new thread for updater {}", (Object)updater);
            this.nonPollingUpdaterPool.execute(runUpdater);
        }
        this.reportReadinessForUpdaters();
    }

    public void stop() {
        this.stop(true);
    }

    public void stop(boolean cancelRunningTasks) {
        LOG.info("Stopping updater manager with {} updaters.", (Object)this.numberOfUpdaters());
        if (cancelRunningTasks) {
            this.pollingUpdaterPool.shutdownNow();
            this.nonPollingUpdaterPool.shutdownNow();
        } else {
            this.pollingUpdaterPool.shutdown();
            this.nonPollingUpdaterPool.shutdown();
        }
        try {
            boolean ok;
            boolean bl = ok = this.pollingUpdaterPool.awaitTermination(15L, TimeUnit.SECONDS) && this.nonPollingUpdaterPool.awaitTermination(15L, TimeUnit.SECONDS);
            if (!ok) {
                LOG.warn("Timeout waiting for updaters to finish.");
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for updaters to finish.");
        }
        for (GraphUpdater updater : this.updaterList) {
            updater.teardown();
        }
        this.updaterList.clear();
        this.scheduler.shutdownNow();
        try {
            boolean ok = this.scheduler.awaitTermination(30L, TimeUnit.SECONDS);
            if (!ok) {
                LOG.warn("Timeout waiting for scheduled task to finish.");
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for scheduled task to finish.");
        }
        LOG.info("Stopped updater manager");
    }

    @Override
    public Future<?> execute(GraphWriterRunnable runnable) {
        return this.scheduler.submit(() -> {
            try {
                runnable.run(this.realtimeUpdateContext);
            }
            catch (Exception e) {
                LOG.error("Error while running graph writer {}:", (Object)runnable.getClass().getName(), (Object)e);
            }
        });
    }

    @Override
    public int numberOfUpdaters() {
        return this.updaterList.size();
    }

    @Override
    public List<String> listUnprimedUpdaters() {
        return this.updaterList.stream().filter(Predicate.not(GraphUpdater::isPrimed)).map(GraphUpdater::getConfigRef).collect(Collectors.toList());
    }

    @Override
    public Map<Integer, String> getUpdaterDescriptions() {
        TreeMap<Integer, String> ret = new TreeMap<Integer, String>();
        int i = 0;
        for (GraphUpdater updater : this.updaterList) {
            ret.put(i++, updater.toString());
        }
        return ret;
    }

    public GraphUpdater getUpdater(int id) {
        if (id >= this.updaterList.size()) {
            return null;
        }
        return this.updaterList.get(id);
    }

    @Override
    public Class<?> getUpdaterClass(int id) {
        GraphUpdater updater = this.getUpdater(id);
        return updater == null ? null : updater.getClass();
    }

    public List<GraphUpdater> getUpdaterList() {
        return this.updaterList;
    }

    public ExecutorService getPollingUpdaterPool() {
        return this.pollingUpdaterPool;
    }

    public ExecutorService getNonPollingUpdaterPool() {
        return this.nonPollingUpdaterPool;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    private void reportReadinessForUpdaters() {
        Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("updater-ready").build()).submit(() -> {
            boolean otpIsShuttingDown = false;
            while (!otpIsShuttingDown) {
                try {
                    if (this.updaterList.stream().allMatch(GraphUpdater::isPrimed)) {
                        LOG.info("OTP UPDATERS INITIALIZED ({} updaters) - OTP {} is ready for routing!", (Object)this.updaterList.size(), (Object)OtpProjectInfo.projectInfo().version);
                        return;
                    }
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    otpIsShuttingDown = true;
                    LOG.info("OTP is shutting down, cancelling wait for updaters readiness.");
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }
}

