/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater;

import org.opentripplanner.model.TimetableSnapshot;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.updater.RealTimeUpdateContext;
import org.opentripplanner.updater.trip.gtfs.GtfsRealtimeFuzzyTripMatcher;
import org.opentripplanner.updater.trip.siri.EntityResolver;
import org.opentripplanner.updater.trip.siri.SiriFuzzyTripMatcher;

public class DefaultRealTimeUpdateContext
implements RealTimeUpdateContext {
    private final Graph graph;
    private final TransitService transitService;
    private SiriFuzzyTripMatcher siriFuzzyTripMatcher;

    public DefaultRealTimeUpdateContext(Graph graph, TimetableRepository timetableRepository, TimetableSnapshot timetableSnapshotBuffer) {
        this.graph = graph;
        this.transitService = new DefaultTransitService(timetableRepository, timetableSnapshotBuffer);
    }

    public DefaultRealTimeUpdateContext(Graph graph, TimetableRepository timetableRepository) {
        this(graph, timetableRepository, null);
    }

    @Override
    public Graph graph() {
        return this.graph;
    }

    @Override
    public TransitService transitService() {
        return this.transitService;
    }

    @Override
    public synchronized SiriFuzzyTripMatcher siriFuzzyTripMatcher() {
        if (this.siriFuzzyTripMatcher == null) {
            this.siriFuzzyTripMatcher = new SiriFuzzyTripMatcher(this.transitService);
        }
        return this.siriFuzzyTripMatcher;
    }

    @Override
    public GtfsRealtimeFuzzyTripMatcher gtfsRealtimeFuzzyTripMatcher() {
        return new GtfsRealtimeFuzzyTripMatcher(this.transitService);
    }

    @Override
    public EntityResolver entityResolver(String feedId) {
        return new EntityResolver(this.transitService, feedId);
    }
}

