/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.service;

import gnu.trove.set.TIntSet;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.ext.flex.FlexIndex;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.model.StopTimesInPattern;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.model.calendar.CalendarService;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransitData;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.api.request.FindRegularStopsByBoundingBoxRequest;
import org.opentripplanner.transit.api.request.FindRoutesRequest;
import org.opentripplanner.transit.api.request.FindStopLocationsRequest;
import org.opentripplanner.transit.api.request.TripOnServiceDateRequest;
import org.opentripplanner.transit.api.request.TripRequest;
import org.opentripplanner.transit.api.request.TripTimeOnDateRequest;
import org.opentripplanner.transit.model.basic.Notice;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.GroupOfRoutes;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.site.StopLocationsGroup;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripIdAndServiceDate;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.service.ArrivalDeparture;
import org.opentripplanner.updater.GraphUpdaterStatus;

public interface TransitService {
    public Optional<List<TripTimeOnDate>> getScheduledTripTimes(Trip var1);

    public Optional<List<TripTimeOnDate>> findTripTimesOnDate(Trip var1, LocalDate var2);

    public Collection<String> listFeedIds();

    public Collection<Agency> listAgencies();

    public Optional<Agency> findAgency(FeedScopedId var1);

    public FeedInfo getFeedInfo(String var1);

    public Collection<Notice> findNotices(AbstractTransitEntity<?, ?> var1);

    public TripPattern getTripPattern(FeedScopedId var1);

    public Collection<TripPattern> listTripPatterns();

    public Station getStation(FeedScopedId var1);

    public MultiModalStation getMultiModalStation(FeedScopedId var1);

    public Collection<Station> listStations();

    public Integer getServiceCode(FeedScopedId var1);

    public TIntSet getServiceCodesRunningForDate(LocalDate var1);

    public Agency getAgency(FeedScopedId var1);

    public Route getRoute(FeedScopedId var1);

    public Collection<Route> getRoutes(Collection<FeedScopedId> var1);

    public Set<Route> findRoutes(StopLocation var1);

    public Collection<TripPattern> findPatterns(StopLocation var1);

    public Collection<TripPattern> findPatterns(StopLocation var1, boolean var2);

    public Collection<Operator> listOperators();

    public Operator getOperator(FeedScopedId var1);

    @Nullable
    public RegularStop getRegularStop(FeedScopedId var1);

    public Collection<StopLocation> listStopLocations();

    public Collection<GroupStop> listGroupStops();

    public StopLocation getStopLocation(FeedScopedId var1);

    public Collection<StopLocation> findStopOrChildStops(FeedScopedId var1);

    default public List<FeedScopedId> findStopOrChildIds(FeedScopedId id) {
        return this.findStopOrChildStops(id).stream().map(StopLocation::getId).distinct().toList();
    }

    public Collection<StopLocationsGroup> listStopLocationGroups();

    public StopLocationsGroup getStopLocationsGroup(FeedScopedId var1);

    @Nullable
    public Trip getTrip(FeedScopedId var1);

    public Collection<Trip> listTrips();

    public List<TripOnServiceDate> listCanceledTrips();

    public Collection<Route> listRoutes();

    public TripPattern findPattern(Trip var1);

    public TripPattern findPattern(Trip var1, LocalDate var2);

    public Collection<TripPattern> findPatterns(Route var1);

    public MultiModalStation findMultiModalStation(Station var1);

    public List<StopTimesInPattern> findStopTimesInPattern(StopLocation var1, Instant var2, Duration var3, int var4, ArrivalDeparture var5, boolean var6);

    public List<StopTimesInPattern> findStopTimesInPattern(StopLocation var1, LocalDate var2, ArrivalDeparture var3, boolean var4);

    public List<TripTimeOnDate> findTripTimesOnDate(StopLocation var1, TripPattern var2, Instant var3, Duration var4, int var5, ArrivalDeparture var6, boolean var7);

    public List<TripTimeOnDate> findTripTimesOnDate(TripTimeOnDateRequest var1);

    public Collection<GroupOfRoutes> listGroupsOfRoutes();

    public Collection<Route> findRoutes(GroupOfRoutes var1);

    @Nullable
    public GroupOfRoutes getGroupOfRoutes(FeedScopedId var1);

    public Timetable findTimetable(TripPattern var1, LocalDate var2);

    @Nullable
    public TripPattern findNewTripPatternForModifiedTrip(FeedScopedId var1, LocalDate var2);

    public boolean hasNewTripPatternsForModifiedTrips();

    public TripOnServiceDate getTripOnServiceDate(TripIdAndServiceDate var1);

    public TripOnServiceDate getTripOnServiceDate(FeedScopedId var1);

    public Collection<TripOnServiceDate> listTripsOnServiceDate();

    public Collection<PathTransfer> findPathTransfers(StopLocation var1);

    public RaptorTransitData getRaptorTransitData();

    public RaptorTransitData getRealtimeRaptorTransitData();

    public CalendarService getCalendarService();

    public ZoneId getTimeZone();

    public TransitAlertService getTransitAlertService();

    public FlexIndex getFlexIndex();

    public ZonedDateTime getTransitServiceEnds();

    public ZonedDateTime getTransitServiceStarts();

    public TransferService getTransferService();

    public boolean transitFeedCovers(Instant var1);

    public Collection<RegularStop> findRegularStopsByBoundingBox(Envelope var1);

    public Collection<AreaStop> findAreaStops(Envelope var1);

    public GraphUpdaterStatus getUpdaterStatus();

    public List<TransitMode> findTransitModes(StopLocationsGroup var1);

    public List<TransitMode> findTransitModes(StopLocation var1);

    public Deduplicator getDeduplicator();

    public Set<LocalDate> listServiceDates();

    public Map<LocalDate, TIntSet> getServiceCodesRunningForDate();

    public List<TripOnServiceDate> findTripsOnServiceDate(TripOnServiceDateRequest var1);

    public List<Trip> getTrips(TripRequest var1);

    public boolean containsTrip(FeedScopedId var1);

    public Optional<RegularStop> findStopByScheduledStopPoint(FeedScopedId var1);

    public Collection<RegularStop> findRegularStopsByBoundingBox(FindRegularStopsByBoundingBoxRequest var1);

    public Collection<Route> findRoutes(FindRoutesRequest var1);

    public Collection<StopLocation> findStopLocations(FindStopLocationsRequest var1);

    public boolean hasScheduledServicesAfter(LocalDate var1, StopLocation var2);
}

