/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.service;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.ext.flex.FlexIndex;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.model.calendar.CalendarService;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.GroupOfRoutes;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripIdAndServiceDate;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.service.TimetableRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimetableRepositoryIndex {
    private static final Logger LOG = LoggerFactory.getLogger(TimetableRepositoryIndex.class);
    private final Map<FeedScopedId, Agency> agencyForId = new HashMap<FeedScopedId, Agency>();
    private final Map<FeedScopedId, Operator> operatorForId = new HashMap<FeedScopedId, Operator>();
    private final Map<FeedScopedId, Trip> tripForId = new HashMap<FeedScopedId, Trip>();
    private final Map<FeedScopedId, Route> routeForId = new HashMap<FeedScopedId, Route>();
    private final Map<Trip, TripPattern> patternForTrip = new HashMap<Trip, TripPattern>();
    private final Multimap<Route, TripPattern> patternsForRoute = ArrayListMultimap.create();
    private final Multimap<StopLocation, TripPattern> patternsForStop = ArrayListMultimap.create();
    private Map<StopLocation, LocalDate> endOfServiceDateForStop = new HashMap<StopLocation, LocalDate>();
    private final Map<LocalDate, TIntSet> serviceCodesRunningForDate = new HashMap<LocalDate, TIntSet>();
    private final Map<TripIdAndServiceDate, TripOnServiceDate> tripOnServiceDateForTripAndDay = new HashMap<TripIdAndServiceDate, TripOnServiceDate>();
    private final Multimap<GroupOfRoutes, Route> routesForGroupOfRoutes = ArrayListMultimap.create();
    private final Map<FeedScopedId, GroupOfRoutes> groupOfRoutesForId = new HashMap<FeedScopedId, GroupOfRoutes>();
    private FlexIndex flexIndex = null;

    TimetableRepositoryIndex(TimetableRepository timetableRepository) {
        LOG.info("Timetable repository index init...");
        for (Agency agency : timetableRepository.getAgencies()) {
            this.agencyForId.put(agency.getId(), agency);
        }
        for (Operator operator : timetableRepository.getOperators()) {
            this.operatorForId.put(operator.getId(), operator);
        }
        for (TripPattern tripPattern : timetableRepository.getAllTripPatterns()) {
            this.patternsForRoute.put((Object)tripPattern.getRoute(), (Object)tripPattern);
            tripPattern.scheduledTripsAsStream().forEach(trip -> {
                this.patternForTrip.put((Trip)trip, pattern);
                this.tripForId.put(trip.getId(), (Trip)trip);
            });
            for (StopLocation stop : tripPattern.getStops()) {
                this.patternsForStop.put((Object)stop, (Object)tripPattern);
            }
        }
        for (Route route : this.patternsForRoute.asMap().keySet()) {
            this.routeForId.put(route.getId(), route);
            for (GroupOfRoutes groupOfRoutes : route.getGroupsOfRoutes()) {
                this.routesForGroupOfRoutes.put((Object)groupOfRoutes, (Object)route);
            }
        }
        for (GroupOfRoutes groupOfRoutes : this.routesForGroupOfRoutes.keySet()) {
            this.groupOfRoutesForId.put(groupOfRoutes.getId(), groupOfRoutes);
        }
        for (TripOnServiceDate tripOnServiceDate : timetableRepository.getAllTripsOnServiceDates()) {
            this.tripOnServiceDateForTripAndDay.put(new TripIdAndServiceDate(tripOnServiceDate.getTrip().getId(), tripOnServiceDate.getServiceDate()), tripOnServiceDate);
        }
        this.initializeServiceData(timetableRepository);
        if (OTPFeature.FlexRouting.isOn()) {
            this.flexIndex = new FlexIndex(timetableRepository);
            for (Route route : this.flexIndex.getAllFlexRoutes()) {
                this.routeForId.put(route.getId(), route);
            }
            for (FlexTrip flexTrip : this.flexIndex.getAllFlexTrips()) {
                this.tripForId.put(flexTrip.getId(), flexTrip.getTrip());
            }
        }
        LOG.info("Timetable repository index init complete.");
    }

    Agency getAgencyForId(FeedScopedId id) {
        return this.agencyForId.get(id);
    }

    Route getRouteForId(FeedScopedId id) {
        return this.routeForId.get(id);
    }

    Set<Route> getRoutesForStop(StopLocation stop) {
        HashSet<Route> routes = new HashSet<Route>();
        for (TripPattern p : this.patternsForStop.get((Object)stop)) {
            routes.add(p.getRoute());
        }
        return routes;
    }

    Collection<TripPattern> getPatternsForStop(StopLocation stop) {
        return Collections.unmodifiableCollection(this.patternsForStop.get((Object)stop));
    }

    Collection<Trip> getTripsForStop(StopLocation stop) {
        return this.patternsForStop.get((Object)stop).stream().flatMap(TripPattern::scheduledTripsAsStream).collect(Collectors.toList());
    }

    boolean hasScheduledServicesAfter(LocalDate date, StopLocation stop) {
        LocalDate endOfServiceDate = this.endOfServiceDateForStop.get(stop);
        return endOfServiceDate != null && (endOfServiceDate.isAfter(date) || endOfServiceDate.isEqual(date));
    }

    Operator getOperatorForId(FeedScopedId operatorId) {
        return this.operatorForId.get(operatorId);
    }

    Collection<Trip> getAllTrips() {
        return Collections.unmodifiableCollection(this.tripForId.values());
    }

    Trip getTripForId(FeedScopedId tripId) {
        return this.tripForId.get(tripId);
    }

    boolean containsTrip(FeedScopedId tripId) {
        return this.tripForId.containsKey(tripId);
    }

    TripOnServiceDate getTripOnServiceDateForTripAndDay(TripIdAndServiceDate tripIdAndServiceDate) {
        return this.tripOnServiceDateForTripAndDay.get(tripIdAndServiceDate);
    }

    Collection<Route> getAllRoutes() {
        return Collections.unmodifiableCollection(this.routeForId.values());
    }

    TripPattern getPatternForTrip(Trip trip) {
        return this.patternForTrip.get(trip);
    }

    Collection<TripPattern> getPatternsForRoute(Route route) {
        return Collections.unmodifiableCollection(this.patternsForRoute.get((Object)route));
    }

    Map<LocalDate, TIntSet> getServiceCodesRunningForDate() {
        return this.serviceCodesRunningForDate;
    }

    FlexIndex getFlexIndex() {
        return this.flexIndex;
    }

    private void initializeServiceData(TimetableRepository timetableRepository) {
        CalendarService calendarService = timetableRepository.getCalendarService();
        if (calendarService == null) {
            return;
        }
        HashMultimap serviceIdsForServiceDate = HashMultimap.create();
        HashMap<FeedScopedId, LocalDate> endOfServiceDateForService = new HashMap<FeedScopedId, LocalDate>();
        for (FeedScopedId serviceId : calendarService.getServiceIds()) {
            Set<LocalDate> serviceDatesForService = calendarService.getServiceDatesForServiceId(serviceId);
            for (LocalDate serviceDate : serviceDatesForService) {
                serviceIdsForServiceDate.put((Object)serviceDate, (Object)serviceId);
                if (endOfServiceDateForService.get(serviceId) != null && (serviceDate == null || !serviceDate.isAfter((ChronoLocalDate)endOfServiceDateForService.get(serviceId)))) continue;
                endOfServiceDateForService.put(serviceId, serviceDate);
            }
        }
        for (LocalDate serviceDate : serviceIdsForServiceDate.keySet()) {
            TIntHashSet serviceCodesRunning = new TIntHashSet();
            for (FeedScopedId serviceId : serviceIdsForServiceDate.get((Object)serviceDate)) {
                serviceCodesRunning.add(timetableRepository.getServiceCodes().get(serviceId).intValue());
            }
            this.serviceCodesRunningForDate.put(serviceDate, (TIntSet)serviceCodesRunning);
        }
        this.initializeTheEndOfServiceDateForStop(endOfServiceDateForService);
    }

    private void initializeTheEndOfServiceDateForStop(Map<FeedScopedId, LocalDate> endOfServiceDateForService) {
        HashMap endOfServiceDates = new HashMap();
        for (StopLocation stop : this.patternsForStop.keySet()) {
            for (TripPattern pattern : this.patternsForStop.get((Object)stop)) {
                pattern.scheduledTripsAsStream().forEach(trip -> {
                    LocalDate tripEndDate = (LocalDate)endOfServiceDateForService.get(trip.getServiceId());
                    LocalDate endOfServiceDate = (LocalDate)endOfServiceDates.get(stop);
                    if (tripEndDate != null && (endOfServiceDate == null || tripEndDate.isAfter(endOfServiceDate))) {
                        endOfServiceDates.put(stop, tripEndDate);
                    }
                });
            }
        }
        this.endOfServiceDateForStop = Map.copyOf(endOfServiceDates);
    }

    Collection<GroupOfRoutes> getAllGroupOfRoutes() {
        return Collections.unmodifiableCollection(this.groupOfRoutesForId.values());
    }

    Collection<Route> getRoutesForGroupOfRoutes(GroupOfRoutes groupOfRoutes) {
        return Collections.unmodifiableCollection(this.routesForGroupOfRoutes.get((Object)groupOfRoutes));
    }

    GroupOfRoutes getGroupOfRoutesForId(FeedScopedId id) {
        return this.groupOfRoutesForId.get(id);
    }
}

