/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.service;

import com.google.common.collect.MinMaxPriorityQueue;
import gnu.trove.set.TIntSet;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopTimesInPattern;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.transit.api.request.TripTimeOnDateRequest;
import org.opentripplanner.transit.model.filter.expr.Matcher;
import org.opentripplanner.transit.model.filter.transit.TripTimeOnDateMatcherFactory;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.ArrivalDeparture;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.transit.service.TripTimesHelper;
import org.opentripplanner.utils.time.ServiceDateUtils;

class StopTimesHelper {
    private final TransitService transitService;

    StopTimesHelper(TransitService transitService) {
        this.transitService = transitService;
    }

    List<StopTimesInPattern> stopTimesForStop(StopLocation stop, Instant startTime, Duration timeRange, int numberOfDepartures, ArrivalDeparture arrivalDeparture, boolean includeCancelledTrips, Comparator<TripTimeOnDate> sortOrder) {
        if (numberOfDepartures <= 0) {
            return List.of();
        }
        ArrayList<StopTimesInPattern> result = new ArrayList<StopTimesInPattern>();
        Collection<TripPattern> patterns = this.transitService.findPatterns(stop, true);
        for (TripPattern pattern : patterns) {
            Queue<TripTimeOnDate> pq = this.listTripTimeOnDatesForPatternAtStop(stop, pattern, startTime, timeRange, numberOfDepartures, arrivalDeparture, includeCancelledTrips, false, sortOrder);
            result.addAll(StopTimesHelper.getStopTimesInPattern(pattern, pq));
        }
        return result;
    }

    List<TripTimeOnDate> findTripTimesOnDate(TripTimeOnDateRequest request) {
        Matcher<TripTimeOnDate> matcher = TripTimeOnDateMatcherFactory.of(request);
        return request.stopLocations().stream().flatMap(stopLocation -> this.stopTimesForStop((StopLocation)stopLocation, request.time(), request.timeWindow(), request.numberOfDepartures(), request.arrivalDeparture(), true, request.sortOrder()).stream().flatMap(st -> st.times.stream()).filter(matcher::match)).sorted(request.sortOrder()).toList();
    }

    List<StopTimesInPattern> stopTimesForStop(StopLocation stop, LocalDate serviceDate, ArrivalDeparture arrivalDeparture, boolean includeCancellations) {
        ArrayList<StopTimesInPattern> ret = new ArrayList<StopTimesInPattern>();
        TIntSet servicesRunning = this.transitService.getServiceCodesRunningForDate(serviceDate);
        Instant midnight = ServiceDateUtils.asStartOfService((LocalDate)serviceDate, (ZoneId)this.transitService.getTimeZone()).toInstant();
        for (TripPattern pattern : this.transitService.findPatterns(stop, true)) {
            StopTimesInPattern stopTimes = new StopTimesInPattern(pattern);
            Timetable tt = this.transitService.findTimetable(pattern, serviceDate);
            List<StopLocation> stops = pattern.getStops();
            for (int i = 0; i < stops.size(); ++i) {
                StopLocation currStop = stops.get(i);
                if (currStop != stop || StopTimesHelper.skipByPickUpDropOff(pattern, arrivalDeparture, i) || StopTimesHelper.skipByStopCancellation(pattern, includeCancellations, i)) continue;
                for (TripTimes t : tt.getTripTimes()) {
                    if (TripTimesHelper.skipByTripCancellation(t, includeCancellations) || !servicesRunning.contains(t.getServiceCode())) continue;
                    stopTimes.times.add(new TripTimeOnDate(t, i, pattern, serviceDate, midnight));
                }
            }
            ret.add(stopTimes);
        }
        return ret;
    }

    List<TripTimeOnDate> stopTimesForPatternAtStop(StopLocation stop, TripPattern pattern, Instant startTime, Duration timeRange, int numberOfDepartures, ArrivalDeparture arrivalDeparture, boolean includeCancellations) {
        Queue<TripTimeOnDate> pq = this.listTripTimeOnDatesForPatternAtStop(stop, pattern, startTime, timeRange, numberOfDepartures, arrivalDeparture, includeCancellations, true, TripTimeOnDate.compareByDeparture());
        return new ArrayList<TripTimeOnDate>(pq);
    }

    private static List<StopTimesInPattern> getStopTimesInPattern(TripPattern pattern, Queue<TripTimeOnDate> pq) {
        ArrayList<StopTimesInPattern> result = new ArrayList<StopTimesInPattern>();
        if (!pq.isEmpty()) {
            StopTimesInPattern stopTimes = new StopTimesInPattern(pattern);
            while (!pq.isEmpty()) {
                stopTimes.times.add(0, pq.poll());
            }
            result.add(stopTimes);
        }
        return result;
    }

    private Queue<TripTimeOnDate> listTripTimeOnDatesForPatternAtStop(StopLocation stop, TripPattern pattern, Instant startTime, Duration timeRange, int numberOfDepartures, ArrivalDeparture arrivalDeparture, boolean includeCancellations, boolean includeReplaced, Comparator<TripTimeOnDate> sortOrder) {
        ZoneId zoneId = this.transitService.getTimeZone();
        LocalDate startDate = startTime.atZone(zoneId).toLocalDate().minusDays(1L);
        LocalDate endDate = startTime.plus(timeRange).atZone(zoneId).toLocalDate();
        List<LocalDate> serviceDates = startDate.datesUntil(endDate.plusDays(1L)).toList();
        MinMaxPriorityQueue pq = MinMaxPriorityQueue.orderedBy(sortOrder).maximumSize(numberOfDepartures).create();
        int timeRangeSeconds = (int)timeRange.toSeconds();
        for (LocalDate serviceDate : serviceDates) {
            Timetable timetable = this.transitService.findTimetable(pattern, serviceDate);
            ZonedDateTime midnight = ServiceDateUtils.asStartOfService((LocalDate)serviceDate, (ZoneId)zoneId);
            int secondsSinceMidnight = ServiceDateUtils.secondsSinceStartOfService((ZonedDateTime)midnight, (ZonedDateTime)ZonedDateTime.ofInstant(startTime, zoneId));
            TIntSet servicesRunning = this.transitService.getServiceCodesRunningForDate(serviceDate);
            List<StopLocation> stops = pattern.getStops();
            for (int stopPos = 0; stopPos < stops.size(); ++stopPos) {
                StopLocation currStop = stops.get(stopPos);
                if (currStop != stop || StopTimesHelper.skipByPickUpDropOff(pattern, arrivalDeparture, stopPos) || StopTimesHelper.skipByStopCancellation(pattern, includeCancellations, stopPos)) continue;
                for (TripTimes tripTimes : timetable.getTripTimes()) {
                    boolean arrivalTimeInRange;
                    if (!servicesRunning.contains(tripTimes.getServiceCode()) || TripTimesHelper.skipByTripCancellation(tripTimes, includeCancellations) || !includeReplaced && StopTimesHelper.isReplacedByAnotherPattern(tripTimes.getTrip(), serviceDate, pattern, this.transitService)) continue;
                    boolean departureTimeInRange = tripTimes.getDepartureTime(stopPos) >= secondsSinceMidnight && tripTimes.getDepartureTime(stopPos) <= secondsSinceMidnight + timeRangeSeconds;
                    boolean bl = arrivalTimeInRange = tripTimes.getArrivalTime(stopPos) >= secondsSinceMidnight && tripTimes.getArrivalTime(stopPos) <= secondsSinceMidnight + timeRangeSeconds;
                    if ((arrivalDeparture == ArrivalDeparture.ARRIVALS || !departureTimeInRange) && (arrivalDeparture == ArrivalDeparture.DEPARTURES || !arrivalTimeInRange)) continue;
                    pq.add((Object)new TripTimeOnDate(tripTimes, stopPos, pattern, serviceDate, midnight.toInstant()));
                }
            }
        }
        return pq;
    }

    private static boolean isReplacedByAnotherPattern(Trip trip, LocalDate serviceDate, TripPattern pattern, TransitService transitService) {
        TripPattern replacement = transitService.findNewTripPatternForModifiedTrip(trip.getId(), serviceDate);
        return replacement != null && !replacement.equals(pattern);
    }

    private static boolean skipByPickUpDropOff(TripPattern pattern, ArrivalDeparture arrivalDeparture, int stopPos) {
        boolean noPickup = pattern.getBoardType(stopPos).is(PickDrop.NONE);
        boolean noDropoff = pattern.getAlightType(stopPos).is(PickDrop.NONE);
        if (noPickup && noDropoff) {
            return true;
        }
        if (noPickup && arrivalDeparture == ArrivalDeparture.DEPARTURES) {
            return true;
        }
        return noDropoff && arrivalDeparture == ArrivalDeparture.ARRIVALS;
    }

    private static boolean skipByStopCancellation(TripPattern pattern, boolean includeCancelled, int stopPos) {
        boolean pickupCancelled = pattern.getBoardType(stopPos).is(PickDrop.CANCELLED);
        boolean dropOffCancelled = pattern.getAlightType(stopPos).is(PickDrop.CANCELLED);
        return (pickupCancelled || dropOffCancelled) && !includeCancelled;
    }
}

