/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.framework.geometry.HashGridSpatialIndex;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.utils.collection.CollectionsView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

class SiteRepositoryIndex {
    private static final Logger LOG = LoggerFactory.getLogger(SiteRepositoryIndex.class);
    private final HashGridSpatialIndex<RegularStop> regularStopSpatialIndex = new HashGridSpatialIndex();
    private final Map<Station, MultiModalStation> multiModalStationForStations = new HashMap<Station, MultiModalStation>();
    private final HashGridSpatialIndex<AreaStop> locationIndex = new HashGridSpatialIndex();
    private final StopLocation[] stopsByIndex;

    SiteRepositoryIndex(Collection<RegularStop> stops, Collection<AreaStop> flexStops, Collection<GroupStop> groupStops, Collection<MultiModalStation> multiModalStations, int indexSize) {
        this.stopsByIndex = new StopLocation[indexSize];
        CollectionsView allStops = new CollectionsView(new Collection[]{stops, flexStops, groupStops});
        for (StopLocation stopLocation : allStops) {
            if (stopLocation instanceof RegularStop) {
                RegularStop regularStop = (RegularStop)stopLocation;
                Envelope envelope = new Envelope(stopLocation.getCoordinate().asJtsCoordinate());
                this.regularStopSpatialIndex.insert(envelope, (Object)regularStop);
            }
            this.stopsByIndex[stopLocation.getIndex()] = stopLocation;
        }
        for (MultiModalStation multiModalStation : multiModalStations) {
            for (Station childStation : multiModalStation.getChildStations()) {
                this.multiModalStationForStations.put(childStation, multiModalStation);
            }
        }
        for (AreaStop areaStop : flexStops) {
            this.locationIndex.insert(areaStop.getGeometry().getEnvelopeInternal(), (Object)areaStop);
        }
        this.regularStopSpatialIndex.compact();
        this.locationIndex.compact();
        this.logHolesInIndex();
    }

    Collection<RegularStop> findRegularStops(Envelope envelope) {
        return this.regularStopSpatialIndex.query(envelope).stream().filter(stop -> envelope.contains(stop.getCoordinate().asJtsCoordinate())).toList();
    }

    MultiModalStation getMultiModalStationForStation(Station station) {
        return this.multiModalStationForStations.get(station);
    }

    @Nullable
    StopLocation stopByIndex(int index) {
        return this.stopsByIndex[index];
    }

    int stopIndexSize() {
        return this.stopsByIndex.length;
    }

    Collection<AreaStop> findAreaStops(Envelope envelope) {
        return this.locationIndex.query(envelope);
    }

    private void logHolesInIndex() {
        int c = (int)Arrays.stream(this.stopsByIndex).filter(Objects::isNull).count();
        if (c > 0) {
            double p = 100.0 * (double)c / (double)this.stopsByIndex.length;
            LOG.atLevel(p >= 5.0 ? Level.WARN : Level.INFO).log("The stop index contains holes in it. {} of {} is null.", (Object)c, (Object)this.stopsByIndex.length);
        }
    }
}

