/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.service;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.opentripplanner.transit.model.framework.DefaultEntityById;
import org.opentripplanner.transit.model.framework.EntityById;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.ImmutableEntityById;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.AreaStopBuilder;
import org.opentripplanner.transit.model.site.GroupOfStations;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.GroupStopBuilder;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.RegularStopBuilder;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.service.SiteRepository;

public class SiteRepositoryBuilder {
    private final AtomicInteger stopIndexCounter;
    private final EntityById<RegularStop> regularStopById = new DefaultEntityById<RegularStop>();
    private final EntityById<AreaStop> areaStopById = new DefaultEntityById<AreaStop>();
    private final EntityById<GroupStop> groupStopById = new DefaultEntityById<GroupStop>();
    private final EntityById<Station> stationById = new DefaultEntityById<Station>();
    private final EntityById<MultiModalStation> multiModalStationById = new DefaultEntityById<MultiModalStation>();
    private final EntityById<GroupOfStations> groupOfStationById = new DefaultEntityById<GroupOfStations>();

    SiteRepositoryBuilder(AtomicInteger stopIndexCounter) {
        this.stopIndexCounter = stopIndexCounter;
    }

    public ImmutableEntityById<RegularStop> regularStopsById() {
        return this.regularStopById;
    }

    public RegularStopBuilder regularStop(FeedScopedId id) {
        return RegularStop.of(id, this.stopIndexCounter::getAndIncrement);
    }

    public RegularStop computeRegularStopIfAbsent(FeedScopedId id, Function<FeedScopedId, RegularStop> factory) {
        return this.regularStopById.computeIfAbsent(id, factory);
    }

    public SiteRepositoryBuilder withRegularStop(RegularStop stop) {
        this.regularStopById.add(stop);
        return this;
    }

    public SiteRepositoryBuilder withRegularStops(Collection<RegularStop> stops) {
        this.regularStopById.addAll(stops);
        return this;
    }

    public ImmutableEntityById<Station> stationById() {
        return this.stationById;
    }

    public SiteRepositoryBuilder withStation(Station station) {
        this.stationById.add(station);
        return this;
    }

    public Station computeStationIfAbsent(FeedScopedId id, Function<FeedScopedId, Station> body) {
        return this.stationById.computeIfAbsent(id, body::apply);
    }

    public SiteRepositoryBuilder withStations(Collection<Station> stations) {
        this.stationById.addAll(stations);
        return this;
    }

    public ImmutableEntityById<MultiModalStation> multiModalStationById() {
        return this.multiModalStationById;
    }

    public SiteRepositoryBuilder withMultiModalStation(MultiModalStation station) {
        this.multiModalStationById.add(station);
        return this;
    }

    public ImmutableEntityById<GroupOfStations> groupOfStationById() {
        return this.groupOfStationById;
    }

    public SiteRepositoryBuilder withGroupOfStation(GroupOfStations station) {
        this.groupOfStationById.add(station);
        return this;
    }

    public AreaStopBuilder areaStop(FeedScopedId id) {
        return AreaStop.of(id, this.stopIndexCounter::getAndIncrement);
    }

    public ImmutableEntityById<AreaStop> areaStopById() {
        return this.areaStopById;
    }

    public SiteRepositoryBuilder withAreaStop(AreaStop stop) {
        this.areaStopById.add(stop);
        return this;
    }

    public SiteRepositoryBuilder withAreaStops(Collection<AreaStop> stops) {
        this.areaStopById.addAll(stops);
        return this;
    }

    public GroupStopBuilder groupStop(FeedScopedId id) {
        return GroupStop.of(id, this.stopIndexCounter::getAndIncrement);
    }

    public ImmutableEntityById<GroupStop> groupStopById() {
        return this.groupStopById;
    }

    public SiteRepositoryBuilder withGroupStop(GroupStop group) {
        this.groupStopById.add(group);
        return this;
    }

    public SiteRepositoryBuilder withGroupStops(Collection<GroupStop> groups) {
        this.groupStopById.addAll(groups);
        return this;
    }

    public SiteRepositoryBuilder addAll(SiteRepository other) {
        this.regularStopById.addAll(other.listRegularStops());
        this.stationById.addAll(other.listStations());
        this.multiModalStationById.addAll(other.listMultiModalStations());
        this.groupOfStationById.addAll(other.listGroupOfStations());
        this.areaStopById.addAll(other.listAreaStops());
        this.groupStopById.addAll(other.listGroupStops());
        return this;
    }

    public SiteRepository build() {
        return new SiteRepository(this);
    }

    AtomicInteger stopIndexCounter() {
        return this.stopIndexCounter;
    }
}

