/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.service;

import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.GroupOfStations;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.site.StopLocationsGroup;
import org.opentripplanner.transit.service.SiteRepositoryBuilder;
import org.opentripplanner.transit.service.SiteRepositoryIndex;
import org.opentripplanner.utils.collection.CollectionsView;
import org.opentripplanner.utils.collection.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteRepository
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(SiteRepository.class);
    private final AtomicInteger stopIndexCounter;
    private final Map<FeedScopedId, RegularStop> regularStopById;
    private final Map<FeedScopedId, Station> stationById;
    private final Map<FeedScopedId, MultiModalStation> multiModalStationById;
    private final Map<FeedScopedId, GroupOfStations> groupOfStationsById;
    private final Map<FeedScopedId, AreaStop> areaStopById;
    private final Map<FeedScopedId, GroupStop> groupStopById;
    private transient SiteRepositoryIndex index;

    @Inject
    public SiteRepository() {
        this.stopIndexCounter = new AtomicInteger(0);
        this.regularStopById = Map.of();
        this.stationById = Map.of();
        this.multiModalStationById = Map.of();
        this.groupOfStationsById = Map.of();
        this.areaStopById = Map.of();
        this.groupStopById = Map.of();
        this.index = this.createIndex();
    }

    SiteRepository(SiteRepositoryBuilder builder) {
        this.stopIndexCounter = builder.stopIndexCounter();
        this.regularStopById = builder.regularStopsById().asImmutableMap();
        this.stationById = builder.stationById().asImmutableMap();
        this.multiModalStationById = builder.multiModalStationById().asImmutableMap();
        this.groupOfStationsById = builder.groupOfStationById().asImmutableMap();
        this.areaStopById = builder.areaStopById().asImmutableMap();
        this.groupStopById = builder.groupStopById().asImmutableMap();
        this.reindex();
    }

    private SiteRepository(SiteRepository main, SiteRepository child) {
        this.stopIndexCounter = SiteRepository.assertSameStopIndexCounterIsUsedToCreateBothModels(main, child);
        this.areaStopById = MapUtils.combine((Map[])new Map[]{main.areaStopById, child.areaStopById});
        this.regularStopById = MapUtils.combine((Map[])new Map[]{main.regularStopById, child.regularStopById});
        this.groupOfStationsById = MapUtils.combine((Map[])new Map[]{main.groupOfStationsById, child.groupOfStationsById});
        this.groupStopById = MapUtils.combine((Map[])new Map[]{main.groupStopById, child.groupStopById});
        this.multiModalStationById = MapUtils.combine((Map[])new Map[]{main.multiModalStationById, child.multiModalStationById});
        this.stationById = MapUtils.combine((Map[])new Map[]{main.stationById, child.stationById});
        this.reindex();
    }

    public static SiteRepositoryBuilder of() {
        return new SiteRepositoryBuilder(new AtomicInteger(0));
    }

    public SiteRepositoryBuilder withContext() {
        return new SiteRepositoryBuilder(this.stopIndexCounter);
    }

    public RegularStop getRegularStop(FeedScopedId id) {
        return this.regularStopById.get(id);
    }

    public Collection<RegularStop> listRegularStops() {
        return this.regularStopById.values();
    }

    public Collection<RegularStop> findRegularStops(Envelope envelope) {
        return this.index.findRegularStops(envelope);
    }

    public boolean hasAreaStops() {
        return !this.areaStopById.isEmpty();
    }

    @Nullable
    public AreaStop getAreaStop(FeedScopedId id) {
        return this.areaStopById.get(id);
    }

    public Collection<AreaStop> listAreaStops() {
        return this.areaStopById.values();
    }

    public Collection<AreaStop> findAreaStops(Envelope envelope) {
        return this.index.findAreaStops(envelope);
    }

    public Collection<GroupStop> listGroupStops() {
        return this.groupStopById.values();
    }

    @Nullable
    public StopLocation stopByIndex(int stopIndex) {
        return this.index.stopByIndex(stopIndex);
    }

    public int stopIndexSize() {
        return this.index.stopIndexSize();
    }

    @Nullable
    public StopLocation getStopLocation(FeedScopedId id) {
        return (StopLocation)SiteRepository.getById(id, this.regularStopById, this.areaStopById, this.groupStopById);
    }

    public Collection<StopLocation> listStopLocations() {
        return new CollectionsView(new Collection[]{this.regularStopById.values(), this.areaStopById.values(), this.groupStopById.values()});
    }

    @Nullable
    public Station getStationById(FeedScopedId id) {
        return this.stationById.get(id);
    }

    public Collection<Station> listStations() {
        return this.stationById.values();
    }

    @Nullable
    public MultiModalStation getMultiModalStation(FeedScopedId id) {
        return this.multiModalStationById.get(id);
    }

    public Collection<MultiModalStation> listMultiModalStations() {
        return this.multiModalStationById.values();
    }

    @Nullable
    public MultiModalStation getMultiModalStationForStation(Station station) {
        return this.index.getMultiModalStationForStation(station);
    }

    public Collection<GroupOfStations> listGroupOfStations() {
        return this.groupOfStationsById.values();
    }

    @Nullable
    public StopLocationsGroup getStopLocationsGroup(FeedScopedId id) {
        return (StopLocationsGroup)SiteRepository.getById(id, this.stationById, this.multiModalStationById, this.groupOfStationsById);
    }

    public Collection<StopLocationsGroup> listStopLocationGroups() {
        return new CollectionsView(new Collection[]{this.stationById.values(), this.multiModalStationById.values(), this.groupOfStationsById.values()});
    }

    @Nullable
    public WgsCoordinate getCoordinateById(FeedScopedId id) {
        GroupOfStations groupOfStations = this.groupOfStationsById.get(id);
        if (groupOfStations != null) {
            return groupOfStations.getCoordinate();
        }
        MultiModalStation multiModalStation = this.multiModalStationById.get(id);
        if (multiModalStation != null) {
            return multiModalStation.getCoordinate();
        }
        Station station = this.stationById.get(id);
        if (station != null) {
            return station.getCoordinate();
        }
        StopLocation stop = this.getStopLocation(id);
        return stop == null ? null : stop.getCoordinate();
    }

    public Collection<StopLocation> findStopOrChildStops(FeedScopedId id) {
        StopLocationsGroup stops = this.getStopLocationsGroup(id);
        if (stops != null) {
            return stops.getChildStops();
        }
        StopLocation stop = this.getStopLocation(id);
        return stop == null ? List.of() : List.of(stop);
    }

    public void reindexAfterDeserialization() {
        this.reindex();
    }

    public SiteRepository merge(SiteRepository child) {
        return new SiteRepository(this, child);
    }

    private void reindex() {
        LOG.info("Index site repository...");
        this.index = this.createIndex();
        LOG.info("Index site repository complete.");
    }

    private SiteRepositoryIndex createIndex() {
        return new SiteRepositoryIndex(this.regularStopById.values(), this.areaStopById.values(), this.groupStopById.values(), this.multiModalStationById.values(), this.stopIndexCounter.get());
    }

    @Nullable
    @SafeVarargs
    private static <V> V getById(FeedScopedId id, Map<FeedScopedId, ? extends V> ... maps) {
        if (id == null) {
            return null;
        }
        for (Map<FeedScopedId, V> map : maps) {
            V v = map.get(id);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private static AtomicInteger assertSameStopIndexCounterIsUsedToCreateBothModels(SiteRepository main, SiteRepository child) {
        if (main.stopIndexCounter != child.stopIndexCounter) {
            throw new IllegalArgumentException("Two Stop repositories can only be merged if they are created with the same stopIndexCounter. This is archived by using the 'SiteRepository.withContext()' method. We do this to avoid duplicates/gaps in the stopIndex.");
        }
        return main.stopIndexCounter;
    }
}

