/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.service;

import java.time.LocalDate;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import org.opentripplanner.apis.gtfs.model.LocalDateRange;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.Trip;

public class PatternByServiceDatesFilter {
    private final Function<Route, Collection<TripPattern>> getPatternsForRoute;
    private final Function<Trip, Collection<LocalDate>> getServiceDatesForTrip;
    private final LocalDateRange range;

    public PatternByServiceDatesFilter(LocalDateRange range, Function<Route, Collection<TripPattern>> getPatternsForRoute, Function<Trip, Collection<LocalDate>> getServiceDatesForTrip) {
        this.getPatternsForRoute = Objects.requireNonNull(getPatternsForRoute);
        this.getServiceDatesForTrip = Objects.requireNonNull(getServiceDatesForTrip);
        this.range = range;
        if (range.unlimited()) {
            throw new IllegalArgumentException("start and end cannot be both null");
        }
        if (range.startBeforeEnd()) {
            throw new IllegalArgumentException("start must be before end");
        }
    }

    public Collection<TripPattern> filterPatterns(Collection<TripPattern> tripPatterns) {
        return tripPatterns.stream().filter(this::hasServicesOnDate).toList();
    }

    public Collection<Route> filterRoutes(Collection<Route> routeStream) {
        return routeStream.stream().filter(r -> {
            Collection<TripPattern> patterns = this.getPatternsForRoute.apply((Route)r);
            return !this.filterPatterns(patterns).isEmpty();
        }).toList();
    }

    private boolean hasServicesOnDate(TripPattern pattern) {
        return pattern.scheduledTripsAsStream().anyMatch(trip -> {
            Collection<LocalDate> dates = this.getServiceDatesForTrip.apply((Trip)trip);
            return dates.stream().anyMatch(this.range::contains);
        });
    }
}

