/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.service;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.ext.flex.FlexIndex;
import org.opentripplanner.framework.application.OTPRequestTimeoutException;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.model.StopTimesInPattern;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TimetableSnapshot;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.model.calendar.CalendarService;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransitData;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.api.request.FindRegularStopsByBoundingBoxRequest;
import org.opentripplanner.transit.api.request.FindRoutesRequest;
import org.opentripplanner.transit.api.request.FindStopLocationsRequest;
import org.opentripplanner.transit.api.request.TripOnServiceDateRequest;
import org.opentripplanner.transit.api.request.TripRequest;
import org.opentripplanner.transit.api.request.TripTimeOnDateRequest;
import org.opentripplanner.transit.model.basic.Notice;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.filter.expr.Matcher;
import org.opentripplanner.transit.model.filter.transit.RegularStopMatcherFactory;
import org.opentripplanner.transit.model.filter.transit.RouteMatcherFactory;
import org.opentripplanner.transit.model.filter.transit.StopLocationMatcherFactory;
import org.opentripplanner.transit.model.filter.transit.TripMatcherFactory;
import org.opentripplanner.transit.model.filter.transit.TripOnServiceDateMatcherFactory;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.GroupOfRoutes;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.site.StopLocationsGroup;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripIdAndServiceDate;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.ArrivalDeparture;
import org.opentripplanner.transit.service.StopTimesHelper;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.transit.service.TimetableRepositoryIndex;
import org.opentripplanner.transit.service.TransitEditorService;
import org.opentripplanner.updater.GraphUpdaterStatus;
import org.opentripplanner.utils.collection.CollectionsView;
import org.opentripplanner.utils.time.ServiceDateUtils;

public class DefaultTransitService
implements TransitEditorService {
    private final TimetableRepository timetableRepository;
    private final TimetableRepositoryIndex timetableRepositoryIndex;
    @Nullable
    private final TimetableSnapshot timetableSnapshot;
    private final StopTimesHelper stopTimesHelper;

    public DefaultTransitService(TimetableRepository timetableRepository) {
        this(timetableRepository, null);
    }

    @Inject
    public DefaultTransitService(TimetableRepository timetableRepository, @Nullable TimetableSnapshot timetableSnapshot) {
        this.timetableRepository = timetableRepository;
        this.timetableRepositoryIndex = timetableRepository.getTimetableRepositoryIndex();
        this.timetableSnapshot = timetableSnapshot;
        this.stopTimesHelper = new StopTimesHelper(this);
    }

    @Override
    public Optional<List<TripTimeOnDate>> getScheduledTripTimes(Trip trip) {
        TripPattern tripPattern = this.findPattern(trip);
        return Optional.ofNullable(TripTimeOnDate.fromTripTimes(tripPattern.getScheduledTimetable(), trip));
    }

    @Override
    public Optional<List<TripTimeOnDate>> findTripTimesOnDate(Trip trip, LocalDate serviceDate) {
        TripPattern pattern = this.findPattern(trip, serviceDate);
        Timetable timetable = this.findTimetable(pattern, serviceDate);
        TripTimes times = timetable.getTripTimes(trip);
        if (times == null || !this.getServiceCodesRunningForDate(serviceDate).contains(times.getServiceCode())) {
            return Optional.empty();
        }
        Instant midnight = ServiceDateUtils.asStartOfService((LocalDate)serviceDate, (ZoneId)this.getTimeZone()).toInstant();
        return Optional.of(TripTimeOnDate.fromTripTimes(timetable, trip, serviceDate, midnight));
    }

    @Override
    public Collection<String> listFeedIds() {
        return this.timetableRepository.getFeedIds();
    }

    @Override
    public Collection<Agency> listAgencies() {
        OTPRequestTimeoutException.checkForTimeout();
        return this.timetableRepository.getAgencies();
    }

    @Override
    public Optional<Agency> findAgency(FeedScopedId id) {
        return this.timetableRepository.findAgencyById(id);
    }

    @Override
    public FeedInfo getFeedInfo(String feedId) {
        return this.timetableRepository.getFeedInfo(feedId);
    }

    @Override
    public Collection<Notice> findNotices(AbstractTransitEntity<?, ?> entity) {
        return this.timetableRepository.getNoticesByElement().get(entity);
    }

    @Override
    public TripPattern getTripPattern(FeedScopedId id) {
        return this.timetableRepository.getTripPatternForId(id);
    }

    @Override
    public Collection<TripPattern> listTripPatterns() {
        OTPRequestTimeoutException.checkForTimeout();
        return this.timetableRepository.getAllTripPatterns();
    }

    @Override
    public Station getStation(FeedScopedId id) {
        return this.timetableRepository.getSiteRepository().getStationById(id);
    }

    @Override
    public MultiModalStation getMultiModalStation(FeedScopedId id) {
        return this.timetableRepository.getSiteRepository().getMultiModalStation(id);
    }

    @Override
    public Collection<Station> listStations() {
        OTPRequestTimeoutException.checkForTimeout();
        return this.timetableRepository.getSiteRepository().listStations();
    }

    @Override
    public Integer getServiceCode(FeedScopedId id) {
        return this.timetableRepository.getServiceCodes().get(id);
    }

    @Override
    public TIntSet getServiceCodesRunningForDate(LocalDate serviceDate) {
        return this.timetableRepositoryIndex.getServiceCodesRunningForDate().getOrDefault(serviceDate, (TIntSet)new TIntHashSet());
    }

    @Override
    public Agency getAgency(FeedScopedId id) {
        return this.timetableRepositoryIndex.getAgencyForId(id);
    }

    @Override
    public RegularStop getRegularStop(FeedScopedId id) {
        return this.timetableRepository.getSiteRepository().getRegularStop(id);
    }

    @Override
    public Route getRoute(FeedScopedId id) {
        Route realtimeAddedRoute;
        if (this.timetableSnapshot != null && (realtimeAddedRoute = this.timetableSnapshot.getRealtimeAddedRoute(id)) != null) {
            return realtimeAddedRoute;
        }
        return this.timetableRepositoryIndex.getRouteForId(id);
    }

    @Override
    public Collection<Route> getRoutes(Collection<FeedScopedId> ids) {
        return ids.stream().map(this::getRoute).filter(Objects::nonNull).toList();
    }

    @Override
    public Collection<Route> findRoutes(FindRoutesRequest request) {
        Matcher<Route> matcher = RouteMatcherFactory.of(request, this.getFlexIndex()::contains);
        return this.listRoutes().stream().filter(matcher::match).toList();
    }

    @Override
    public Set<Route> findRoutes(StopLocation stop) {
        OTPRequestTimeoutException.checkForTimeout();
        return this.timetableRepositoryIndex.getRoutesForStop(stop);
    }

    @Override
    public Collection<TripPattern> findPatterns(StopLocation stop) {
        OTPRequestTimeoutException.checkForTimeout();
        return this.timetableRepositoryIndex.getPatternsForStop(stop);
    }

    @Override
    public Collection<Operator> listOperators() {
        OTPRequestTimeoutException.checkForTimeout();
        return this.timetableRepository.getOperators();
    }

    @Override
    public Operator getOperator(FeedScopedId id) {
        return this.timetableRepositoryIndex.getOperatorForId(id);
    }

    @Override
    public Collection<StopLocation> listStopLocations() {
        OTPRequestTimeoutException.checkForTimeout();
        return this.timetableRepository.getSiteRepository().listStopLocations();
    }

    @Override
    public Collection<GroupStop> listGroupStops() {
        OTPRequestTimeoutException.checkForTimeout();
        return this.timetableRepository.getSiteRepository().listGroupStops();
    }

    @Override
    public StopLocation getStopLocation(FeedScopedId id) {
        return this.timetableRepository.getSiteRepository().getStopLocation(id);
    }

    @Override
    public Collection<StopLocation> findStopLocations(FindStopLocationsRequest request) {
        Matcher<StopLocation> matcher = StopLocationMatcherFactory.of(request);
        return this.listStopLocations().stream().filter(matcher::match).toList();
    }

    @Override
    public Collection<StopLocation> findStopOrChildStops(FeedScopedId id) {
        return this.timetableRepository.getSiteRepository().findStopOrChildStops(id);
    }

    @Override
    public Collection<StopLocationsGroup> listStopLocationGroups() {
        OTPRequestTimeoutException.checkForTimeout();
        return this.timetableRepository.getSiteRepository().listStopLocationGroups();
    }

    @Override
    public StopLocationsGroup getStopLocationsGroup(FeedScopedId id) {
        return this.timetableRepository.getSiteRepository().getStopLocationsGroup(id);
    }

    @Override
    public Trip getTrip(FeedScopedId id) {
        Trip trip;
        if (this.timetableSnapshot != null && (trip = this.timetableSnapshot.getRealTimeAddedTrip(id)) != null) {
            return trip;
        }
        return this.getScheduledTrip(id);
    }

    @Override
    @Nullable
    public Trip getScheduledTrip(FeedScopedId id) {
        return this.timetableRepositoryIndex.getTripForId(id);
    }

    @Override
    public List<TripOnServiceDate> listCanceledTrips() {
        OTPRequestTimeoutException.checkForTimeout();
        if (this.timetableSnapshot == null) {
            return List.of();
        }
        List<TripOnServiceDate> canceledTrips = this.timetableSnapshot.listCanceledTrips();
        canceledTrips.sort(new TripOnServiceDateComparator());
        return canceledTrips;
    }

    @Override
    public Collection<Trip> listTrips() {
        OTPRequestTimeoutException.checkForTimeout();
        if (this.timetableSnapshot != null) {
            return new CollectionsView(new Collection[]{this.timetableRepositoryIndex.getAllTrips(), this.timetableSnapshot.listRealTimeAddedTrips()});
        }
        return Collections.unmodifiableCollection(this.timetableRepositoryIndex.getAllTrips());
    }

    @Override
    public Collection<Route> listRoutes() {
        OTPRequestTimeoutException.checkForTimeout();
        if (this.timetableSnapshot != null) {
            return new CollectionsView(new Collection[]{this.timetableRepositoryIndex.getAllRoutes(), this.timetableSnapshot.listRealTimeAddedRoutes()});
        }
        return this.timetableRepositoryIndex.getAllRoutes();
    }

    @Override
    public TripPattern findPattern(Trip trip) {
        TripPattern realtimeAddedTripPattern;
        if (this.timetableSnapshot != null && (realtimeAddedTripPattern = this.timetableSnapshot.getRealTimeAddedPatternForTrip(trip)) != null) {
            return realtimeAddedTripPattern;
        }
        return this.timetableRepositoryIndex.getPatternForTrip(trip);
    }

    @Override
    public TripPattern findPattern(Trip trip, LocalDate serviceDate) {
        TripPattern realtimePattern = this.findNewTripPatternForModifiedTrip(trip.getId(), serviceDate);
        if (realtimePattern != null) {
            return realtimePattern;
        }
        return this.findPattern(trip);
    }

    @Override
    public Collection<TripPattern> findPatterns(Route route) {
        OTPRequestTimeoutException.checkForTimeout();
        HashSet<TripPattern> tripPatterns = new HashSet<TripPattern>(this.timetableRepositoryIndex.getPatternsForRoute(route));
        if (this.timetableSnapshot != null) {
            Collection<TripPattern> realTimeAddedPatternForRoute = this.timetableSnapshot.getRealTimeAddedPatternForRoute(route);
            tripPatterns.addAll(realTimeAddedPatternForRoute);
        }
        return tripPatterns;
    }

    @Override
    public MultiModalStation findMultiModalStation(Station station) {
        return this.timetableRepository.getSiteRepository().getMultiModalStationForStation(station);
    }

    @Override
    public List<StopTimesInPattern> findStopTimesInPattern(StopLocation stop, Instant startTime, Duration timeRange, int numberOfDepartures, ArrivalDeparture arrivalDeparture, boolean includeCancelledTrips) {
        OTPRequestTimeoutException.checkForTimeout();
        return this.stopTimesHelper.stopTimesForStop(stop, startTime, timeRange, numberOfDepartures, arrivalDeparture, includeCancelledTrips, TripTimeOnDate.compareByDeparture());
    }

    @Override
    public List<StopTimesInPattern> findStopTimesInPattern(StopLocation stop, LocalDate serviceDate, ArrivalDeparture arrivalDeparture, boolean includeCancellations) {
        OTPRequestTimeoutException.checkForTimeout();
        return this.stopTimesHelper.stopTimesForStop(stop, serviceDate, arrivalDeparture, includeCancellations);
    }

    @Override
    public List<TripTimeOnDate> findTripTimesOnDate(StopLocation stop, TripPattern pattern, Instant startTime, Duration timeRange, int numberOfDepartures, ArrivalDeparture arrivalDeparture, boolean includeCancellations) {
        OTPRequestTimeoutException.checkForTimeout();
        return this.stopTimesHelper.stopTimesForPatternAtStop(stop, pattern, startTime, timeRange, numberOfDepartures, arrivalDeparture, includeCancellations);
    }

    @Override
    public List<TripTimeOnDate> findTripTimesOnDate(TripTimeOnDateRequest request) {
        OTPRequestTimeoutException.checkForTimeout();
        return this.stopTimesHelper.findTripTimesOnDate(request);
    }

    @Override
    public Collection<TripPattern> findPatterns(StopLocation stop, boolean includeRealtimeUpdates) {
        HashSet<TripPattern> tripPatterns = new HashSet<TripPattern>(this.findPatterns(stop));
        if (includeRealtimeUpdates && this.timetableSnapshot != null) {
            tripPatterns.addAll(this.timetableSnapshot.getPatternsForStop(stop));
        }
        return tripPatterns;
    }

    @Override
    public Collection<GroupOfRoutes> listGroupsOfRoutes() {
        OTPRequestTimeoutException.checkForTimeout();
        return this.timetableRepositoryIndex.getAllGroupOfRoutes();
    }

    @Override
    public Collection<Route> findRoutes(GroupOfRoutes groupOfRoutes) {
        OTPRequestTimeoutException.checkForTimeout();
        return this.timetableRepositoryIndex.getRoutesForGroupOfRoutes(groupOfRoutes);
    }

    @Override
    public GroupOfRoutes getGroupOfRoutes(FeedScopedId id) {
        return this.timetableRepositoryIndex.getGroupOfRoutesForId(id);
    }

    @Override
    public Timetable findTimetable(TripPattern tripPattern, LocalDate serviceDate) {
        OTPRequestTimeoutException.checkForTimeout();
        return this.timetableSnapshot != null ? this.timetableSnapshot.resolve(tripPattern, serviceDate) : tripPattern.getScheduledTimetable();
    }

    @Override
    public TripPattern findNewTripPatternForModifiedTrip(FeedScopedId tripId, LocalDate serviceDate) {
        if (this.timetableSnapshot == null) {
            return null;
        }
        return this.timetableSnapshot.getNewTripPatternForModifiedTrip(tripId, serviceDate);
    }

    @Override
    public boolean hasNewTripPatternsForModifiedTrips() {
        if (this.timetableSnapshot == null) {
            return false;
        }
        return this.timetableSnapshot.hasNewTripPatternsForModifiedTrips();
    }

    @Override
    public TripOnServiceDate getTripOnServiceDate(FeedScopedId id) {
        TripOnServiceDate tripOnServiceDate;
        if (this.timetableSnapshot != null && (tripOnServiceDate = this.timetableSnapshot.getRealTimeAddedTripOnServiceDateById(id)) != null) {
            return tripOnServiceDate;
        }
        return this.timetableRepository.getTripOnServiceDateById(id);
    }

    @Override
    public Collection<TripOnServiceDate> listTripsOnServiceDate() {
        if (this.timetableSnapshot != null) {
            return new CollectionsView(new Collection[]{this.timetableRepository.getAllTripsOnServiceDates(), this.timetableSnapshot.listRealTimeAddedTripOnServiceDate()});
        }
        return this.timetableRepository.getAllTripsOnServiceDates();
    }

    @Override
    public TripOnServiceDate getTripOnServiceDate(TripIdAndServiceDate tripIdAndServiceDate) {
        TripOnServiceDate tripOnServiceDate;
        if (this.timetableSnapshot != null && (tripOnServiceDate = this.timetableSnapshot.getRealTimeAddedTripOnServiceDateForTripAndDay(tripIdAndServiceDate)) != null) {
            return tripOnServiceDate;
        }
        return this.timetableRepositoryIndex.getTripOnServiceDateForTripAndDay(tripIdAndServiceDate);
    }

    @Override
    public List<TripOnServiceDate> findTripsOnServiceDate(TripOnServiceDateRequest request) {
        Matcher<TripOnServiceDate> matcher = TripOnServiceDateMatcherFactory.of(request);
        return this.listTripsOnServiceDate().stream().filter(matcher::match).toList();
    }

    @Override
    public boolean containsTrip(FeedScopedId id) {
        Trip trip;
        if (this.timetableSnapshot != null && (trip = this.timetableSnapshot.getRealTimeAddedTrip(id)) != null) {
            return true;
        }
        return this.timetableRepositoryIndex.containsTrip(id);
    }

    @Override
    public Optional<RegularStop> findStopByScheduledStopPoint(FeedScopedId scheduledStopPoint) {
        return this.timetableRepository.findStopByScheduledStopPoint(scheduledStopPoint);
    }

    @Override
    public List<Trip> getTrips(TripRequest request) {
        Matcher<Trip> matcher = TripMatcherFactory.of(request, this.getCalendarService()::getServiceDatesForServiceId);
        return this.listTrips().stream().filter(matcher::match).toList();
    }

    @Override
    public FeedScopedId getOrCreateServiceIdForDate(LocalDate serviceDate) {
        return this.timetableRepository.getOrCreateServiceIdForDate(serviceDate);
    }

    @Override
    public Collection<PathTransfer> findPathTransfers(StopLocation stop) {
        return this.timetableRepository.getTransfersByStop(stop);
    }

    @Override
    public RaptorTransitData getRaptorTransitData() {
        OTPRequestTimeoutException.checkForTimeout();
        return this.timetableRepository.getRaptorTransitData();
    }

    @Override
    public RaptorTransitData getRealtimeRaptorTransitData() {
        OTPRequestTimeoutException.checkForTimeout();
        return this.timetableRepository.getRealtimeRaptorTransitData();
    }

    @Override
    public CalendarService getCalendarService() {
        return this.timetableRepository.getCalendarService();
    }

    @Override
    public ZoneId getTimeZone() {
        return this.timetableRepository.getTimeZone();
    }

    @Override
    public TransitAlertService getTransitAlertService() {
        return this.timetableRepository.getTransitAlertService();
    }

    @Override
    public FlexIndex getFlexIndex() {
        return this.timetableRepositoryIndex.getFlexIndex();
    }

    @Override
    public ZonedDateTime getTransitServiceEnds() {
        return this.timetableRepository.getTransitServiceEnds();
    }

    @Override
    public ZonedDateTime getTransitServiceStarts() {
        return this.timetableRepository.getTransitServiceStarts();
    }

    @Override
    public Collection<RegularStop> findRegularStopsByBoundingBox(Envelope envelope) {
        OTPRequestTimeoutException.checkForTimeout();
        return this.timetableRepository.getSiteRepository().findRegularStops(envelope);
    }

    @Override
    public Collection<RegularStop> findRegularStopsByBoundingBox(FindRegularStopsByBoundingBoxRequest request) {
        OTPRequestTimeoutException.checkForTimeout();
        Collection<RegularStop> stops = this.timetableRepository.getSiteRepository().findRegularStops(request.envelope());
        Matcher<RegularStop> matcher = RegularStopMatcherFactory.of(request, stop -> !this.findPatterns((StopLocation)stop, true).isEmpty());
        return stops.stream().filter(matcher::match).toList();
    }

    @Override
    public Collection<AreaStop> findAreaStops(Envelope envelope) {
        OTPRequestTimeoutException.checkForTimeout();
        return this.timetableRepository.getSiteRepository().findAreaStops(envelope);
    }

    @Override
    public GraphUpdaterStatus getUpdaterStatus() {
        return this.timetableRepository.getUpdaterManager();
    }

    @Override
    public List<TransitMode> findTransitModes(StopLocationsGroup station) {
        return DefaultTransitService.sortByOccurrenceAndReduce(station.getChildStops().stream().flatMap(this::getPatternModesOfStop)).toList();
    }

    @Override
    public List<TransitMode> findTransitModes(StopLocation stop) {
        return DefaultTransitService.sortByOccurrenceAndReduce(this.getPatternModesOfStop(stop)).toList();
    }

    @Override
    public Deduplicator getDeduplicator() {
        return this.timetableRepository.getDeduplicator();
    }

    @Override
    public Set<LocalDate> listServiceDates() {
        return Collections.unmodifiableSet(this.timetableRepositoryIndex.getServiceCodesRunningForDate().keySet());
    }

    @Override
    public Map<LocalDate, TIntSet> getServiceCodesRunningForDate() {
        return Collections.unmodifiableMap(this.timetableRepositoryIndex.getServiceCodesRunningForDate());
    }

    @Override
    public TransferService getTransferService() {
        return this.timetableRepository.getTransferService();
    }

    @Override
    public boolean transitFeedCovers(Instant dateTime) {
        return this.timetableRepository.transitFeedCovers(dateTime);
    }

    @Override
    public boolean hasScheduledServicesAfter(LocalDate date, StopLocation stop) {
        return this.timetableRepositoryIndex.hasScheduledServicesAfter(date, stop);
    }

    private static <T> Stream<T> sortByOccurrenceAndReduce(Stream<T> input) {
        return input.collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).map(Map.Entry::getKey);
    }

    private Stream<TransitMode> getPatternModesOfStop(StopLocation stop) {
        if (stop.getVehicleType() != null) {
            return Stream.of(stop.getVehicleType());
        }
        return this.findPatterns(stop).stream().map(TripPattern::getMode);
    }

    private int getDepartureTime(TripOnServiceDate trip) {
        TripPattern pattern = this.findPattern(trip.getTrip());
        Timetable timetable = this.timetableSnapshot.resolve(pattern, trip.getServiceDate());
        return timetable.getTripTimes(trip.getTrip()).getDepartureTime(0);
    }

    private class TripOnServiceDateComparator
    implements Comparator<TripOnServiceDate> {
        private TripOnServiceDateComparator() {
        }

        @Override
        public int compare(TripOnServiceDate t1, TripOnServiceDate t2) {
            int departure2;
            if (t1.getServiceDate().isBefore(t2.getServiceDate())) {
                return -1;
            }
            if (t2.getServiceDate().isBefore(t1.getServiceDate())) {
                return 1;
            }
            int departure1 = DefaultTransitService.this.getDepartureTime(t1);
            if (departure1 < (departure2 = DefaultTransitService.this.getDepartureTime(t2))) {
                return -1;
            }
            if (departure1 > departure2) {
                return 1;
            }
            return t1.getTrip().getId().compareTo(t2.getTrip().getId());
        }
    }
}

