/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.timetable.booking;

import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.transit.model.timetable.booking.BookingInfo;
import org.opentripplanner.transit.model.timetable.booking.BookingTime;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public final class RoutingBookingInfo {
    public static final int NOT_SET = -1999999;
    private static final RoutingBookingInfo UNRESTRICTED = new RoutingBookingInfo();
    private final int requestedBookingTime;
    private final int latestBookingTime;
    private final int minimumBookingNotice;

    private RoutingBookingInfo() {
        this.requestedBookingTime = -1999999;
        this.latestBookingTime = -1999999;
        this.minimumBookingNotice = -1999999;
    }

    private RoutingBookingInfo(int requestedBookingTime, int latestBookingTime, int minimumBookingNotice) {
        if (RoutingBookingInfo.notSet(requestedBookingTime)) {
            throw new IllegalArgumentException("The requestedBookingTime must be set.");
        }
        if (RoutingBookingInfo.notSet(latestBookingTime) && RoutingBookingInfo.notSet(minimumBookingNotice)) {
            throw new IllegalArgumentException("At least latestBookingTime or minimumBookingNotice must be set.");
        }
        this.requestedBookingTime = requestedBookingTime;
        this.latestBookingTime = latestBookingTime;
        this.minimumBookingNotice = minimumBookingNotice;
    }

    public static Builder of(int requestedBookingTime) {
        return new Builder(requestedBookingTime);
    }

    public static RoutingBookingInfo of(int requestedBookingTime, @Nullable BookingInfo bookingInfo) {
        return RoutingBookingInfo.of(requestedBookingTime).withBookingInfo(bookingInfo).build();
    }

    public static RoutingBookingInfo unrestricted() {
        return UNRESTRICTED;
    }

    public int earliestDepartureTime(int departureTime) {
        return RoutingBookingInfo.notSet(this.minimumBookingNotice) ? departureTime : Math.max(this.minBookingNoticeLimit(), departureTime);
    }

    public boolean exceedsMinimumBookingNotice(int departureTime) {
        return RoutingBookingInfo.exist(this.minimumBookingNotice) && departureTime < this.minBookingNoticeLimit();
    }

    public boolean exceedsLatestBookingTime() {
        return RoutingBookingInfo.exist(this.latestBookingTime) && this.requestedBookingTime > this.latestBookingTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutingBookingInfo other = (RoutingBookingInfo)o;
        return Objects.equals(this.latestBookingTime, other.latestBookingTime) && Objects.equals(this.minimumBookingNotice, other.minimumBookingNotice);
    }

    public int hashCode() {
        return Objects.hash(this.latestBookingTime, this.minimumBookingNotice);
    }

    public String toString() {
        return ToStringBuilder.of(RoutingBookingInfo.class).addServiceTime("latestBookingTime", this.latestBookingTime, -1999999).addDurationSec("minimumBookingNotice", Integer.valueOf(this.minimumBookingNotice), Integer.valueOf(-1999999)).toString();
    }

    private int minBookingNoticeLimit() {
        return this.requestedBookingTime + this.minimumBookingNotice;
    }

    private static boolean exist(int value) {
        return value != -1999999;
    }

    private static boolean notSet(int value) {
        return value == -1999999;
    }

    public static class Builder {
        private final int requestedBookingTime;
        private int latestBookingTime;
        private int minimumBookingNotice;

        public Builder(int requestedBookingTime) {
            this.requestedBookingTime = requestedBookingTime;
            this.setUnrestricted();
        }

        Builder withBookingInfo(@Nullable BookingInfo bookingInfo) {
            if (bookingInfo == null) {
                this.setUnrestricted();
                return this;
            }
            this.withLatestBookingTime(bookingInfo.getLatestBookingTime());
            this.withMinimumBookingNotice(bookingInfo.getMinimumBookingNotice().orElse(null));
            return this;
        }

        public Builder withLatestBookingTime(@Nullable BookingTime latestBookingTime) {
            this.latestBookingTime = latestBookingTime == null ? -1999999 : latestBookingTime.relativeTimeSeconds();
            return this;
        }

        public Builder withMinimumBookingNotice(@Nullable Duration minimumBookingNotice) {
            this.minimumBookingNotice = minimumBookingNotice == null ? -1999999 : (int)minimumBookingNotice.toSeconds();
            return this;
        }

        public RoutingBookingInfo build() {
            if (RoutingBookingInfo.notSet(this.requestedBookingTime)) {
                return RoutingBookingInfo.unrestricted();
            }
            if (RoutingBookingInfo.notSet(this.latestBookingTime) && RoutingBookingInfo.notSet(this.minimumBookingNotice)) {
                return RoutingBookingInfo.unrestricted();
            }
            return new RoutingBookingInfo(this.requestedBookingTime, this.latestBookingTime, this.minimumBookingNotice);
        }

        private void setUnrestricted() {
            this.latestBookingTime = -1999999;
            this.minimumBookingNotice = -1999999;
        }
    }
}

