/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.timetable.booking;

import java.io.Serializable;
import java.time.LocalTime;
import java.util.Objects;
import org.opentripplanner.utils.time.TimeUtils;

public class BookingTime
implements Serializable {
    private final LocalTime time;
    private final int daysPrior;

    public BookingTime(LocalTime time, int daysPrior) {
        this.time = time;
        this.daysPrior = daysPrior;
    }

    public LocalTime getTime() {
        return this.time;
    }

    public int getDaysPrior() {
        return this.daysPrior;
    }

    public int relativeTimeSeconds() {
        return this.time.toSecondOfDay() - this.daysPrior * TimeUtils.ONE_DAY_SECONDS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingTime that = (BookingTime)o;
        return this.daysPrior == that.daysPrior && Objects.equals(this.time, that.time);
    }

    public int hashCode() {
        return Objects.hash(this.time, this.daysPrior);
    }

    public String toString() {
        return this.daysPrior == 0 ? this.time.toString() : this.time.toString() + "-" + this.daysPrior + "d";
    }
}

