/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.timetable.booking;

import java.io.Serializable;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import org.opentripplanner.transit.model.organization.ContactInfo;
import org.opentripplanner.transit.model.timetable.booking.BookingInfoBuilder;
import org.opentripplanner.transit.model.timetable.booking.BookingMethod;
import org.opentripplanner.transit.model.timetable.booking.BookingTime;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class BookingInfo
implements Serializable {
    private final ContactInfo contactInfo;
    private final EnumSet<BookingMethod> bookingMethods;
    @Nullable
    private final BookingTime earliestBookingTime;
    @Nullable
    private final BookingTime latestBookingTime;
    @Nullable
    private final Duration minimumBookingNotice;
    @Nullable
    private final Duration maximumBookingNotice;
    @Nullable
    private final String message;
    @Nullable
    private final String pickupMessage;
    @Nullable
    private final String dropOffMessage;

    BookingInfo(BookingInfoBuilder builder) {
        this.contactInfo = builder.contactInfo;
        this.bookingMethods = builder.bookingMethods;
        this.message = builder.message;
        this.pickupMessage = builder.pickupMessage;
        this.dropOffMessage = builder.dropOffMessage;
        if (builder.earliestBookingTime != null || builder.latestBookingTime != null) {
            this.earliestBookingTime = builder.earliestBookingTime;
            this.latestBookingTime = builder.latestBookingTime;
            this.minimumBookingNotice = null;
            this.maximumBookingNotice = null;
        } else if (builder.minimumBookingNotice != null || builder.maximumBookingNotice != null) {
            this.earliestBookingTime = null;
            this.latestBookingTime = null;
            this.minimumBookingNotice = builder.minimumBookingNotice;
            this.maximumBookingNotice = builder.maximumBookingNotice;
        } else {
            this.earliestBookingTime = null;
            this.latestBookingTime = null;
            this.minimumBookingNotice = null;
            this.maximumBookingNotice = null;
        }
    }

    public static BookingInfoBuilder of() {
        return new BookingInfoBuilder();
    }

    public ContactInfo getContactInfo() {
        return this.contactInfo;
    }

    public EnumSet<BookingMethod> bookingMethods() {
        return this.bookingMethods;
    }

    @Nullable
    public BookingTime getEarliestBookingTime() {
        return this.earliestBookingTime;
    }

    @Nullable
    public BookingTime getLatestBookingTime() {
        return this.latestBookingTime;
    }

    public Optional<Duration> getMinimumBookingNotice() {
        return Optional.ofNullable(this.minimumBookingNotice);
    }

    public Optional<Duration> getMaximumBookingNotice() {
        return Optional.ofNullable(this.maximumBookingNotice);
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public String getPickupMessage() {
        return this.pickupMessage;
    }

    @Nullable
    public String getDropOffMessage() {
        return this.dropOffMessage;
    }

    public String toString() {
        return ToStringBuilder.of(BookingInfo.class).addObj("contactInfo", (Object)this.contactInfo).addObj("bookingMethods", this.bookingMethods).addObj("earliestBookingTime", (Object)this.earliestBookingTime).addObj("latestBookingTime", (Object)this.latestBookingTime).addDuration("minimumBookingNotice", this.minimumBookingNotice).addDuration("maximumBookingNotice", this.maximumBookingNotice).addStr("message", this.message).addStr("pickupMessage", this.pickupMessage).addStr("dropOffMessage", this.dropOffMessage).toString();
    }
}

