/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.timetable;

import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.utils.time.TimeUtils;

public class TripTimesStringBuilder {
    public static String encodeTripTimes(TripTimes tripTimes, TripPattern pattern) {
        List<StopLocation> stops = pattern.getStops();
        if (tripTimes.getNumStops() != stops.size()) {
            throw new IllegalArgumentException("TripTimes and TripPattern have different number of stops");
        }
        StringBuilder s = new StringBuilder(tripTimes.getRealTimeState().toString());
        for (int i = 0; i < tripTimes.getNumStops(); ++i) {
            int depart = tripTimes.getDepartureTime(i);
            int arrive = tripTimes.getArrivalTime(i);
            ArrayList<String> flags = new ArrayList<String>();
            if (tripTimes.isCancelledStop(i)) {
                flags.add("C");
            }
            if (tripTimes.isRecordedStop(i)) {
                flags.add("R");
            }
            if (tripTimes.isPredictionInaccurate(i)) {
                flags.add("PI");
            }
            if (tripTimes.isNoDataStop(i)) {
                flags.add("ND");
            }
            s.append(" | ").append(stops.get(i).getName());
            if (!flags.isEmpty()) {
                s.append(" [").append(String.join((CharSequence)",", flags)).append("]");
            }
            s.append(" ").append(TimeUtils.timeToStrCompact((int)arrive)).append(" ").append(TimeUtils.timeToStrCompact((int)depart));
        }
        return s.toString();
    }
}

