/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.timetable;

import java.io.Serializable;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.timetable.OccupancyStatus;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.RealTimeTripTimesBuilder;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.booking.BookingInfo;

public interface TripTimes
extends Serializable,
Comparable<TripTimes> {
    public RealTimeTripTimesBuilder createRealTimeWithoutScheduledTimes();

    public RealTimeTripTimesBuilder createRealTimeFromScheduledTimes();

    public int getServiceCode();

    public TripTimes withServiceCode(int var1);

    public int getScheduledArrivalTime(int var1);

    public int getArrivalTime(int var1);

    public int getArrivalDelay(int var1);

    public int getScheduledDepartureTime(int var1);

    public int getDepartureTime(int var1);

    public int getDepartureDelay(int var1);

    public boolean isTimepoint(int var1);

    public Trip getTrip();

    default public int sortIndex() {
        return this.getDepartureTime(0);
    }

    default public Comparator<TripTimes> compare() {
        return Comparator.comparingInt(TripTimes::sortIndex);
    }

    @Override
    default public int compareTo(TripTimes other) {
        return this.sortIndex() - other.sortIndex();
    }

    public BookingInfo getDropOffBookingInfo(int var1);

    public BookingInfo getPickupBookingInfo(int var1);

    public boolean isScheduled();

    public boolean isCanceledOrDeleted();

    public boolean isCanceled();

    public boolean isDeleted();

    public RealTimeState getRealTimeState();

    public boolean isCancelledStop(int var1);

    public boolean isRecordedStop(int var1);

    public boolean isNoDataStop(int var1);

    public boolean isPredictionInaccurate(int var1);

    public boolean isRealTimeUpdated(int var1);

    @Nullable
    public I18NString getTripHeadsign();

    @Nullable
    public I18NString getHeadsign(int var1);

    public List<String> getHeadsignVias(int var1);

    public int getNumStops();

    public Accessibility getWheelchairAccessibility();

    public OccupancyStatus getOccupancyStatus(int var1);

    public int gtfsSequenceOfStopIndex(int var1);

    public OptionalInt stopIndexOfGtfsSequence(int var1);

    public TripTimes adjustTimesToGraphTimeZone(Duration var1);
}

