/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.timetable;

import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripAlteration;
import org.opentripplanner.transit.model.timetable.TripOnServiceDateBuilder;

public class TripOnServiceDate
extends AbstractTransitEntity<TripOnServiceDate, TripOnServiceDateBuilder> {
    private final Trip trip;
    private final LocalDate serviceDate;
    private final TripAlteration tripAlteration;
    private final List<TripOnServiceDate> replacementFor;

    TripOnServiceDate(TripOnServiceDateBuilder builder) {
        super(builder.getId());
        this.trip = builder.getTrip();
        this.serviceDate = builder.getServiceDate();
        this.tripAlteration = builder.getTripAlteration();
        this.replacementFor = builder.getReplacementFor();
    }

    public static TripOnServiceDateBuilder of(FeedScopedId id) {
        return new TripOnServiceDateBuilder(id);
    }

    public Trip getTrip() {
        return this.trip;
    }

    public LocalDate getServiceDate() {
        return this.serviceDate;
    }

    public TripAlteration getTripAlteration() {
        return this.tripAlteration;
    }

    public List<TripOnServiceDate> getReplacementFor() {
        return this.replacementFor;
    }

    @Override
    public boolean sameAs(TripOnServiceDate other) {
        return this.getId().equals(other.getId()) && Objects.equals(this.trip, other.trip) && Objects.equals(this.serviceDate, other.serviceDate) && Objects.equals((Object)this.tripAlteration, (Object)other.tripAlteration) && Objects.equals(this.replacementFor, other.replacementFor);
    }

    public TripOnServiceDateBuilder copy() {
        return new TripOnServiceDateBuilder(this);
    }
}

