/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.timetable;

import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.LogInfo;
import org.opentripplanner.transit.model.network.BikeAccess;
import org.opentripplanner.transit.model.network.CarAccess;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.timetable.Direction;
import org.opentripplanner.transit.model.timetable.TripAlteration;
import org.opentripplanner.transit.model.timetable.TripBuilder;
import org.opentripplanner.utils.lang.ObjectUtils;
import org.opentripplanner.utils.lang.StringUtils;

public final class Trip
extends AbstractTransitEntity<Trip, TripBuilder>
implements LogInfo {
    private final Route route;
    private final TransitMode mode;
    private final Direction direction;
    private final BikeAccess bikesAllowed;
    private final CarAccess carsAllowed;
    private final Accessibility wheelchairBoarding;
    private final SubMode netexSubmode;
    private final TripAlteration netexAlteration;
    @Nullable
    private final Operator operator;
    @Nullable
    private final FeedScopedId serviceId;
    @Nullable
    private final String shortName;
    @Nullable
    private final I18NString headsign;
    @Nullable
    private final FeedScopedId shapeId;
    @Nullable
    private final String gtfsBlockId;
    @Nullable
    private final String netexInternalPlanningCode;

    Trip(TripBuilder builder) {
        super(builder.getId());
        this.route = Objects.requireNonNull(builder.getRoute());
        this.mode = Objects.requireNonNullElse(builder.getMode(), this.route.getMode());
        this.netexSubmode = builder.getNetexSubmode() != null ? SubMode.getOrBuildAndCacheForever(builder.getNetexSubmode()) : this.route.getNetexSubmode();
        this.direction = Objects.requireNonNullElse(builder.getDirection(), Direction.UNKNOWN);
        this.bikesAllowed = Objects.requireNonNullElse(builder.getBikesAllowed(), this.route.getBikesAllowed());
        this.carsAllowed = Objects.requireNonNullElse(builder.getCarsAllowed(), CarAccess.UNKNOWN);
        this.wheelchairBoarding = Objects.requireNonNullElse(builder.getWheelchairBoarding(), Accessibility.NO_INFORMATION);
        this.netexAlteration = Objects.requireNonNullElse(builder.getNetexAlteration(), TripAlteration.PLANNED);
        this.operator = (Operator)ObjectUtils.ifNotNull((Object)builder.getOperator(), (Object)this.route.getOperator());
        this.serviceId = builder.getServiceId();
        this.shortName = builder.getShortName();
        this.headsign = builder.getHeadsign();
        this.shapeId = builder.getShapeId();
        this.gtfsBlockId = builder.getGtfsBlockId();
        this.netexInternalPlanningCode = builder.getNetexInternalPlanningCode();
    }

    public static TripBuilder of(FeedScopedId id) {
        return new TripBuilder(id);
    }

    @Nullable
    public Operator getOperator() {
        return this.operator;
    }

    public Route getRoute() {
        return this.route;
    }

    @Nullable
    public FeedScopedId getServiceId() {
        return this.serviceId;
    }

    @Nullable
    public String getShortName() {
        return this.shortName;
    }

    public TransitMode getMode() {
        return this.mode;
    }

    public SubMode getNetexSubMode() {
        return this.netexSubmode;
    }

    @Nullable
    public I18NString getHeadsign() {
        return this.headsign;
    }

    @Nullable
    public FeedScopedId getShapeId() {
        return this.shapeId;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BikeAccess getBikesAllowed() {
        return this.bikesAllowed;
    }

    public CarAccess getCarsAllowed() {
        return this.carsAllowed;
    }

    public Accessibility getWheelchairBoarding() {
        return this.wheelchairBoarding;
    }

    @Nullable
    public String getGtfsBlockId() {
        return this.gtfsBlockId;
    }

    @Nullable
    public String getNetexInternalPlanningCode() {
        return this.netexInternalPlanningCode;
    }

    public TripAlteration getNetexAlteration() {
        return this.netexAlteration;
    }

    @Override
    public String logName() {
        if (StringUtils.hasValue((String)this.shortName)) {
            return this.shortName;
        }
        if (StringUtils.hasValue((String)this.route.getName())) {
            return this.route.getName();
        }
        if (I18NString.hasValue(this.headsign)) {
            return this.headsign.toString();
        }
        return this.mode.name();
    }

    @Override
    public boolean sameAs(Trip other) {
        return this.getId().equals(other.getId()) && Objects.equals(this.operator, other.operator) && Objects.equals(this.route, other.route) && Objects.equals(this.shortName, other.shortName) && Objects.equals(this.mode, other.mode) && Objects.equals(this.netexSubmode, other.netexSubmode) && Objects.equals(this.serviceId, other.serviceId) && Objects.equals(this.netexInternalPlanningCode, other.netexInternalPlanningCode) && Objects.equals(this.headsign, other.headsign) && Objects.equals(this.gtfsBlockId, other.gtfsBlockId) && Objects.equals(this.shapeId, other.shapeId) && Objects.equals((Object)this.direction, (Object)other.direction) && Objects.equals((Object)this.bikesAllowed, (Object)other.bikesAllowed) && Objects.equals((Object)this.carsAllowed, (Object)other.carsAllowed) && Objects.equals((Object)this.wheelchairBoarding, (Object)other.wheelchairBoarding) && Objects.equals((Object)this.netexAlteration, (Object)other.netexAlteration);
    }

    public TripBuilder copy() {
        return new TripBuilder(this);
    }
}

