/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.timetable;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.transit.model.framework.DeduplicatorService;
import org.opentripplanner.transit.model.timetable.ScheduledTripTimes;
import org.opentripplanner.transit.model.timetable.ScheduledTripTimesBuilder;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.booking.BookingInfo;

class StopTimeToScheduledTripTimesMapper {
    private final Trip trip;
    private final ScheduledTripTimesBuilder builder;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    private StopTimeToScheduledTripTimesMapper(Trip trip, DeduplicatorService deduplicator) {
        this.trip = trip;
        this.builder = ScheduledTripTimes.of(deduplicator).withTrip(trip);
    }

    public static ScheduledTripTimes map(Trip trip, Collection<StopTime> stopTimes, DeduplicatorService deduplicator) {
        return new StopTimeToScheduledTripTimesMapper(trip, deduplicator).doMap(stopTimes);
    }

    private ScheduledTripTimes doMap(Collection<StopTime> stopTimes) {
        int nStops = stopTimes.size();
        int[] departures = new int[nStops];
        int[] arrivals = new int[nStops];
        int[] sequences = new int[nStops];
        BitSet timepoints = new BitSet(nStops);
        ArrayList<BookingInfo> dropOffBookingInfos = new ArrayList<BookingInfo>();
        ArrayList<BookingInfo> pickupBookingInfos = new ArrayList<BookingInfo>();
        int s = 0;
        for (StopTime st : stopTimes) {
            departures[s] = st.getDepartureTime();
            arrivals[s] = st.getArrivalTime();
            sequences[s] = st.getStopSequence();
            timepoints.set(s, st.getTimepoint() == 1);
            dropOffBookingInfos.add(st.getDropOffBookingInfo());
            pickupBookingInfos.add(st.getPickupBookingInfo());
            ++s;
        }
        this.builder.withDepartureTimes(departures).withArrivalTimes(arrivals).withGtfsSequenceOfStopIndex(sequences).withHeadsigns(this.makeHeadsignsArray(stopTimes)).withHeadsignVias(this.makeHeadsignViasArray(stopTimes)).withDropOffBookingInfos(dropOffBookingInfos).withPickupBookingInfos(pickupBookingInfos).withTimepoints(timepoints);
        return this.builder.build();
    }

    private I18NString[] makeHeadsignsArray(Collection<StopTime> stopTimes) {
        I18NString tripHeadsign = this.trip.getHeadsign();
        boolean useStopHeadsigns = false;
        if (tripHeadsign == null) {
            useStopHeadsigns = true;
        } else {
            for (StopTime st : stopTimes) {
                if (tripHeadsign.equals(st.getStopHeadsign())) continue;
                useStopHeadsigns = true;
                break;
            }
        }
        if (!useStopHeadsigns) {
            return null;
        }
        boolean allNull = true;
        int i = 0;
        I18NString[] hs = new I18NString[stopTimes.size()];
        for (StopTime st : stopTimes) {
            I18NString headsign = st.getStopHeadsign();
            hs[i++] = headsign;
            if (headsign == null) continue;
            allNull = false;
        }
        if (allNull) {
            return null;
        }
        return hs;
    }

    @Nullable
    private String[][] makeHeadsignViasArray(Collection<StopTime> stopTimes) {
        if (stopTimes.stream().allMatch(st -> st.getHeadsignVias() == null || st.getHeadsignVias().isEmpty())) {
            return null;
        }
        String[][] vias = new String[stopTimes.size()][];
        int i = 0;
        for (StopTime st2 : stopTimes) {
            if (st2.getHeadsignVias() == null) {
                vias[i] = EMPTY_STRING_ARRAY;
                ++i;
                continue;
            }
            vias[i] = st2.getHeadsignVias().toArray(EMPTY_STRING_ARRAY);
            ++i;
        }
        return vias;
    }
}

