/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.timetable;

import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.transit.model.framework.DeduplicatorService;
import org.opentripplanner.transit.model.timetable.ScheduledTripTimes;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.booking.BookingInfo;
import org.opentripplanner.utils.time.TimeUtils;

public class ScheduledTripTimesBuilder {
    private static final int NOT_SET = -1;
    private static final BitSet EMPTY_BIT_SET = new BitSet(0);
    private int timeShift;
    private int serviceCode;
    private int[] arrivalTimes;
    private int[] departureTimes;
    private BitSet timepoints;
    private Trip trip;
    private List<BookingInfo> dropOffBookingInfos;
    private List<BookingInfo> pickupBookingInfos;
    private I18NString[] headsigns;
    private String[][] headsignVias;
    private int[] gtfsSequenceOfStopIndex;
    private final DeduplicatorService deduplicator;

    ScheduledTripTimesBuilder(@Nullable DeduplicatorService deduplicator) {
        this(0, -1, null, null, null, null, null, null, null, null, null, deduplicator);
    }

    ScheduledTripTimesBuilder(int timeShift, int serviceCode, int[] arrivalTimes, int[] departureTimes, BitSet timepoints, Trip trip, List<BookingInfo> dropOffBookingInfos, List<BookingInfo> pickupBookingInfos, I18NString[] headsigns, String[][] headsignVias, int[] gtfsSequenceOfStopIndex, DeduplicatorService deduplicator) {
        this.timeShift = timeShift;
        this.serviceCode = serviceCode;
        this.arrivalTimes = arrivalTimes;
        this.departureTimes = departureTimes;
        this.timepoints = timepoints;
        this.trip = trip;
        this.dropOffBookingInfos = dropOffBookingInfos;
        this.pickupBookingInfos = pickupBookingInfos;
        this.headsigns = headsigns;
        this.headsignVias = headsignVias;
        this.gtfsSequenceOfStopIndex = gtfsSequenceOfStopIndex;
        this.deduplicator = deduplicator == null ? DeduplicatorService.NOOP : deduplicator;
    }

    public int timeShift() {
        return this.timeShift;
    }

    public ScheduledTripTimesBuilder withTimeShift(int timeShift) {
        this.timeShift = timeShift;
        return this;
    }

    public ScheduledTripTimesBuilder plusTimeShift(int delta) {
        this.timeShift += delta;
        return this;
    }

    public int serviceCode() {
        return this.serviceCode;
    }

    public ScheduledTripTimesBuilder withServiceCode(int serviceCode) {
        this.serviceCode = serviceCode;
        return this;
    }

    public int[] arrivalTimes() {
        return this.arrivalTimes;
    }

    public ScheduledTripTimesBuilder withArrivalTimes(int[] arrivalTimes) {
        this.arrivalTimes = this.deduplicator.deduplicateIntArray(arrivalTimes);
        return this;
    }

    public ScheduledTripTimesBuilder withArrivalTimes(String arrivalTimes) {
        return this.withArrivalTimes(TimeUtils.times((String)arrivalTimes));
    }

    public int[] departureTimes() {
        return this.departureTimes;
    }

    public ScheduledTripTimesBuilder withDepartureTimes(int[] departureTimes) {
        this.departureTimes = this.deduplicator.deduplicateIntArray(departureTimes);
        return this;
    }

    public ScheduledTripTimesBuilder withDepartureTimes(String departureTimes) {
        return this.withDepartureTimes(TimeUtils.times((String)departureTimes));
    }

    public BitSet timepoints() {
        return this.timepoints == null ? EMPTY_BIT_SET : this.timepoints;
    }

    public ScheduledTripTimesBuilder withTimepoints(BitSet timepoints) {
        this.timepoints = this.deduplicator.deduplicateBitSet(timepoints);
        return this;
    }

    public Trip trip() {
        return this.trip;
    }

    public ScheduledTripTimesBuilder withTrip(Trip trip) {
        this.trip = trip;
        return this;
    }

    public List<BookingInfo> dropOffBookingInfos() {
        return this.dropOffBookingInfos == null ? List.of() : this.dropOffBookingInfos;
    }

    public ScheduledTripTimesBuilder withDropOffBookingInfos(List<BookingInfo> dropOffBookingInfos) {
        this.dropOffBookingInfos = this.deduplicator.deduplicateImmutableList(BookingInfo.class, dropOffBookingInfos);
        return this;
    }

    public List<BookingInfo> pickupBookingInfos() {
        return this.pickupBookingInfos == null ? List.of() : this.pickupBookingInfos;
    }

    public ScheduledTripTimesBuilder withPickupBookingInfos(List<BookingInfo> pickupBookingInfos) {
        this.pickupBookingInfos = this.deduplicator.deduplicateImmutableList(BookingInfo.class, pickupBookingInfos);
        return this;
    }

    public I18NString[] headsigns() {
        return this.headsigns;
    }

    public ScheduledTripTimesBuilder withHeadsigns(I18NString[] headsigns) {
        this.headsigns = this.deduplicator.deduplicateObjectArray(I18NString.class, headsigns);
        return this;
    }

    public String[][] headsignVias() {
        return this.headsignVias;
    }

    public ScheduledTripTimesBuilder withHeadsignVias(String[][] headsignVias) {
        this.headsignVias = this.deduplicator.deduplicateString2DArray(headsignVias);
        return this;
    }

    public int[] gtfsSequenceOfStopIndex() {
        return this.gtfsSequenceOfStopIndex;
    }

    public ScheduledTripTimesBuilder withGtfsSequenceOfStopIndex(int[] gtfsSequenceOfStopIndex) {
        this.gtfsSequenceOfStopIndex = this.deduplicator.deduplicateIntArray(gtfsSequenceOfStopIndex);
        return this;
    }

    public ScheduledTripTimes build() {
        this.normalizeTimes();
        return new ScheduledTripTimes(this);
    }

    private void normalizeTimes() {
        int shift;
        if (this.departureTimes == null) {
            this.departureTimes = this.arrivalTimes;
        }
        if (this.arrivalTimes == null) {
            this.arrivalTimes = this.departureTimes;
        }
        if ((shift = this.departureTimes[0]) == 0) {
            return;
        }
        this.departureTimes = this.timeShift(this.departureTimes, shift);
        if (this.arrivalTimes != this.departureTimes) {
            this.arrivalTimes = this.timeShift(this.arrivalTimes, shift);
        }
        this.timeShift += shift;
    }

    int[] timeShift(int[] a, int shift) {
        if (shift == 0) {
            return a;
        }
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] - shift;
        }
        return a;
    }
}

