/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.timetable;

import java.time.Duration;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.opentripplanner.framework.error.OtpError;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.framework.DataValidationException;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.model.framework.DeduplicatorService;
import org.opentripplanner.transit.model.timetable.OccupancyStatus;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.RealTimeTripTimesBuilder;
import org.opentripplanner.transit.model.timetable.ScheduledTripTimesBuilder;
import org.opentripplanner.transit.model.timetable.TimetableValidationError;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.model.timetable.booking.BookingInfo;
import org.opentripplanner.utils.lang.IntUtils;
import org.opentripplanner.utils.time.DurationUtils;
import org.opentripplanner.utils.time.TimeUtils;

public final class ScheduledTripTimes
implements TripTimes {
    private static final int MIN_TIME = DurationUtils.durationInSeconds((String)"-12h");
    private static final int MAX_TIME = DurationUtils.durationInSeconds((String)"20d");
    private final int timeShift;
    private final int serviceCode;
    private final int[] arrivalTimes;
    private final int[] departureTimes;
    private final BitSet timepoints;
    private final Trip trip;
    private final List<BookingInfo> dropOffBookingInfos;
    private final List<BookingInfo> pickupBookingInfos;
    @Nullable
    private final I18NString[] headsigns;
    @Nullable
    private final String[][] headsignVias;
    private final int[] gtfsSequenceOfStopIndex;

    ScheduledTripTimes(ScheduledTripTimesBuilder builder) {
        this.timeShift = builder.timeShift();
        this.serviceCode = builder.serviceCode();
        this.arrivalTimes = Objects.requireNonNull(builder.arrivalTimes());
        this.departureTimes = Objects.requireNonNull(builder.departureTimes());
        this.timepoints = Objects.requireNonNull(builder.timepoints());
        this.trip = Objects.requireNonNull(builder.trip());
        this.pickupBookingInfos = Objects.requireNonNull(builder.pickupBookingInfos());
        this.dropOffBookingInfos = Objects.requireNonNull(builder.dropOffBookingInfos());
        this.headsigns = builder.headsigns();
        this.headsignVias = builder.headsignVias();
        this.gtfsSequenceOfStopIndex = builder.gtfsSequenceOfStopIndex();
        this.validate();
    }

    public static ScheduledTripTimesBuilder of() {
        return new ScheduledTripTimesBuilder(null);
    }

    public static ScheduledTripTimesBuilder of(DeduplicatorService deduplicator) {
        return new ScheduledTripTimesBuilder(deduplicator);
    }

    public ScheduledTripTimesBuilder copyOf(Deduplicator deduplicator) {
        return new ScheduledTripTimesBuilder(this.timeShift, this.serviceCode, this.arrivalTimes, this.departureTimes, this.timepoints, this.trip, this.dropOffBookingInfos, this.pickupBookingInfos, this.headsigns, this.headsignVias, this.gtfsSequenceOfStopIndex, deduplicator);
    }

    public ScheduledTripTimesBuilder copyOfNoDuplication() {
        return this.copyOf(null);
    }

    @Override
    public RealTimeTripTimesBuilder createRealTimeWithoutScheduledTimes() {
        return new RealTimeTripTimesBuilder(this);
    }

    @Override
    public RealTimeTripTimesBuilder createRealTimeFromScheduledTimes() {
        return RealTimeTripTimesBuilder.fromScheduledTimes(this);
    }

    @Override
    public ScheduledTripTimes adjustTimesToGraphTimeZone(Duration shiftDelta) {
        return this.copyOfNoDuplication().plusTimeShift((int)shiftDelta.toSeconds()).build();
    }

    @Override
    public int getServiceCode() {
        return this.serviceCode;
    }

    @Override
    public ScheduledTripTimes withServiceCode(int serviceCode) {
        return this.copyOfNoDuplication().withServiceCode(serviceCode).build();
    }

    @Override
    public int getScheduledArrivalTime(int stop) {
        return this.timeShifted(this.arrivalTimes[stop]);
    }

    @Override
    public int getArrivalTime(int stop) {
        return this.getScheduledArrivalTime(stop);
    }

    @Override
    public int getArrivalDelay(int stop) {
        return this.getArrivalTime(stop) - this.timeShifted(this.arrivalTimes[stop]);
    }

    @Override
    public int getScheduledDepartureTime(int stop) {
        return this.timeShifted(this.departureTimes[stop]);
    }

    @Override
    public int getDepartureTime(int stop) {
        return this.getScheduledDepartureTime(stop);
    }

    @Override
    public int getDepartureDelay(int stop) {
        return this.getDepartureTime(stop) - this.timeShifted(this.departureTimes[stop]);
    }

    @Override
    public boolean isTimepoint(int stopIndex) {
        return this.timepoints.get(stopIndex);
    }

    @Override
    public Trip getTrip() {
        return this.trip;
    }

    @Override
    public int sortIndex() {
        return this.getDepartureTime(0);
    }

    @Override
    public BookingInfo getDropOffBookingInfo(int stop) {
        return this.dropOffBookingInfos.get(stop);
    }

    @Override
    public BookingInfo getPickupBookingInfo(int stop) {
        return this.pickupBookingInfos.get(stop);
    }

    @Override
    public boolean isScheduled() {
        return true;
    }

    @Override
    public boolean isCanceledOrDeleted() {
        return false;
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public RealTimeState getRealTimeState() {
        return RealTimeState.SCHEDULED;
    }

    @Override
    public boolean isCancelledStop(int stop) {
        return false;
    }

    @Override
    public boolean isRecordedStop(int stop) {
        return false;
    }

    @Override
    public boolean isNoDataStop(int stop) {
        return false;
    }

    @Override
    public boolean isPredictionInaccurate(int stop) {
        return false;
    }

    @Override
    public boolean isRealTimeUpdated(int stop) {
        return false;
    }

    @Override
    public I18NString getTripHeadsign() {
        return this.trip.getHeadsign();
    }

    @Override
    @Nullable
    public I18NString getHeadsign(int stop) {
        return this.headsigns != null && this.headsigns[stop] != null ? this.headsigns[stop] : this.getTrip().getHeadsign();
    }

    @Override
    public List<String> getHeadsignVias(int stop) {
        if (this.headsignVias == null || this.headsignVias[stop] == null) {
            return List.of();
        }
        return List.of(this.headsignVias[stop]);
    }

    @Override
    public int getNumStops() {
        return this.arrivalTimes.length;
    }

    @Override
    public Accessibility getWheelchairAccessibility() {
        return this.trip.getWheelchairBoarding();
    }

    @Override
    public OccupancyStatus getOccupancyStatus(int ignore) {
        return OccupancyStatus.NO_DATA_AVAILABLE;
    }

    @Override
    public int gtfsSequenceOfStopIndex(int stop) {
        return this.gtfsSequenceOfStopIndex[stop];
    }

    @Override
    public OptionalInt stopIndexOfGtfsSequence(int stopSequence) {
        if (this.gtfsSequenceOfStopIndex == null) {
            return OptionalInt.empty();
        }
        for (int i = 0; i < this.gtfsSequenceOfStopIndex.length; ++i) {
            int sequence = this.gtfsSequenceOfStopIndex[i];
            if (sequence != stopSequence) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public ScheduledTripTimes timeShift(int stop, int time, boolean depart) {
        int shift = time - (depart ? this.getDepartureTime(stop) : this.getArrivalTime(stop));
        return this.copyOfNoDuplication().plusTimeShift(shift).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledTripTimes that = (ScheduledTripTimes)o;
        return this.timeShift == that.timeShift && this.serviceCode == that.serviceCode && Objects.deepEquals(this.arrivalTimes, that.arrivalTimes) && Objects.deepEquals(this.departureTimes, that.departureTimes) && Objects.equals(this.timepoints, that.timepoints) && Objects.equals(this.trip, that.trip) && Objects.equals(this.dropOffBookingInfos, that.dropOffBookingInfos) && Objects.equals(this.pickupBookingInfos, that.pickupBookingInfos) && Objects.deepEquals(this.headsigns, that.headsigns) && Objects.deepEquals(this.headsignVias, that.headsignVias) && Objects.deepEquals(this.gtfsSequenceOfStopIndex, that.gtfsSequenceOfStopIndex);
    }

    public int hashCode() {
        return Objects.hash(this.timeShift, this.serviceCode, Arrays.hashCode(this.arrivalTimes), Arrays.hashCode(this.departureTimes), this.timepoints, this.trip, this.dropOffBookingInfos, this.pickupBookingInfos, Arrays.hashCode(this.headsigns), Arrays.deepHashCode((Object[])this.headsignVias), Arrays.hashCode(this.gtfsSequenceOfStopIndex));
    }

    int[] copyArrivalTimes() {
        return IntUtils.shiftArray((int)this.timeShift, (int[])this.arrivalTimes);
    }

    int[] copyDepartureTimes() {
        return IntUtils.shiftArray((int)this.timeShift, (int[])this.departureTimes);
    }

    I18NString[] copyHeadsigns(Supplier<I18NString[]> defaultValue) {
        return this.headsigns == null ? defaultValue.get() : Arrays.copyOf(this.headsigns, this.headsigns.length);
    }

    private void validate() {
        this.validateTimeInRange("departureTime", this.departureTimes, 0);
        this.validateTimeInRange("arrivalTime", this.arrivalTimes, this.arrivalTimes.length - 1);
    }

    public void validateNonIncreasingTimes() {
        int lastStop = this.arrivalTimes.length - 1;
        if (lastStop < 1) {
            return;
        }
        int prevDep = this.getDepartureTime(0);
        int i = 1;
        while (true) {
            int arr = this.getArrivalTime(i);
            int dep = this.getDepartureTime(i);
            if (prevDep > arr) {
                throw new DataValidationException(new TimetableValidationError(TimetableValidationError.ErrorCode.NEGATIVE_HOP_TIME, i, this.trip));
            }
            if (i == lastStop) {
                return;
            }
            if (dep < arr) {
                throw new DataValidationException(new TimetableValidationError(TimetableValidationError.ErrorCode.NEGATIVE_DWELL_TIME, i, this.trip));
            }
            prevDep = dep;
            ++i;
        }
    }

    private int timeShifted(int time) {
        return this.timeShift + time;
    }

    private void validateTimeInRange(String field, int[] times, int stopPos) {
        int t = this.timeShifted(times[stopPos]);
        if (t < MIN_TIME || t > MAX_TIME) {
            throw new DataValidationException(OtpError.of("TripTimeOutOfRange", "The %s is not in range[%s, %s]. Time: %s, stop-pos: %d, trip: %s.", field, DurationUtils.durationToStr((int)MIN_TIME), DurationUtils.durationToStr((int)MAX_TIME), TimeUtils.timeToStrLong((int)t), stopPos, this.trip.getId()));
        }
    }
}

