/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.timetable;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.framework.DataValidationException;
import org.opentripplanner.transit.model.timetable.OccupancyStatus;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.RealTimeTripTimes;
import org.opentripplanner.transit.model.timetable.ScheduledTripTimes;
import org.opentripplanner.transit.model.timetable.StopRealTimeState;
import org.opentripplanner.transit.model.timetable.TimetableValidationError;
import org.opentripplanner.transit.model.timetable.Trip;

public class RealTimeTripTimesBuilder {
    private ScheduledTripTimes scheduledTripTimes;
    private final Integer[] arrivalTimes;
    private final Integer[] departureTimes;
    @Nullable
    private RealTimeState realTimeState;
    private final StopRealTimeState[] stopRealTimeStates;
    @Nullable
    private I18NString tripHeadsign;
    private final I18NString[] stopHeadsigns;
    private final OccupancyStatus[] occupancyStatus;
    @Nullable
    private Accessibility wheelchairAccessibility;
    private boolean updated;

    RealTimeTripTimesBuilder(ScheduledTripTimes tripTimes) {
        this.scheduledTripTimes = tripTimes;
        int numStops = tripTimes.getNumStops();
        this.arrivalTimes = new Integer[numStops];
        this.departureTimes = new Integer[numStops];
        this.stopRealTimeStates = new StopRealTimeState[numStops];
        Arrays.fill((Object[])this.stopRealTimeStates, (Object)StopRealTimeState.DEFAULT);
        this.stopHeadsigns = new I18NString[numStops];
        this.occupancyStatus = new OccupancyStatus[numStops];
        Arrays.fill(this.occupancyStatus, OccupancyStatus.NO_DATA_AVAILABLE);
    }

    static RealTimeTripTimesBuilder fromScheduledTimes(ScheduledTripTimes tripTimes) {
        RealTimeTripTimesBuilder instance = new RealTimeTripTimesBuilder(tripTimes);
        instance.copyMissingTimesFromScheduledTimetable();
        return instance;
    }

    public ScheduledTripTimes scheduledTripTimes() {
        return this.scheduledTripTimes;
    }

    public Trip getTrip() {
        return this.scheduledTripTimes.getTrip();
    }

    public int numberOfStops() {
        return this.scheduledTripTimes().getNumStops();
    }

    public int[] arrivalTimes() {
        int[] result = new int[this.arrivalTimes.length];
        for (int i = 0; i < this.arrivalTimes.length; ++i) {
            if (this.arrivalTimes[i] == null) {
                throw new DataValidationException(new TimetableValidationError(TimetableValidationError.ErrorCode.MISSING_ARRIVAL_TIME, i, this.getTrip()));
            }
            result[i] = this.arrivalTimes[i];
        }
        return result;
    }

    @Nullable
    public Integer getArrivalTime(int stop) {
        return this.arrivalTimes[stop];
    }

    public int getScheduledArrivalTime(int stop) {
        return this.scheduledTripTimes().getScheduledArrivalTime(stop);
    }

    @Nullable
    public Integer getArrivalDelay(int stop) {
        if (this.arrivalTimes[stop] == null) {
            return null;
        }
        return this.arrivalTimes[stop] - this.getScheduledArrivalTime(stop);
    }

    public RealTimeTripTimesBuilder withArrivalTime(int stop, int time) {
        this.updated = true;
        this.arrivalTimes[stop] = time;
        return this;
    }

    public RealTimeTripTimesBuilder withArrivalDelay(int stop, int delay) {
        this.updated = true;
        this.arrivalTimes[stop] = this.getScheduledArrivalTime(stop) + delay;
        return this;
    }

    @Nullable
    public Integer getDepartureTime(int stop) {
        return this.departureTimes[stop];
    }

    public int getScheduledDepartureTime(int stop) {
        return this.scheduledTripTimes().getScheduledDepartureTime(stop);
    }

    public int[] departureTimes() {
        int[] result = new int[this.departureTimes.length];
        for (int i = 0; i < this.departureTimes.length; ++i) {
            if (this.departureTimes[i] == null) {
                throw new DataValidationException(new TimetableValidationError(TimetableValidationError.ErrorCode.MISSING_DEPARTURE_TIME, i, this.getTrip()));
            }
            result[i] = this.departureTimes[i];
        }
        return result;
    }

    @Nullable
    public Integer getDepartureDelay(int stop) {
        if (this.departureTimes[stop] == null) {
            return null;
        }
        return this.departureTimes[stop] - this.getScheduledDepartureTime(stop);
    }

    public RealTimeTripTimesBuilder withDepartureTime(int stop, int time) {
        this.updated = true;
        this.departureTimes[stop] = time;
        return this;
    }

    public RealTimeTripTimesBuilder withDepartureDelay(int stop, int delay) {
        this.updated = true;
        this.departureTimes[stop] = this.getScheduledDepartureTime(stop) + delay;
        return this;
    }

    public RealTimeState realTimeState() {
        if (this.realTimeState == null) {
            return this.updated ? RealTimeState.UPDATED : RealTimeState.SCHEDULED;
        }
        return this.realTimeState;
    }

    public RealTimeTripTimesBuilder withRealTimeState(RealTimeState realTimeState) {
        this.realTimeState = realTimeState;
        return this;
    }

    public RealTimeTripTimesBuilder cancelTrip() {
        return this.withRealTimeState(RealTimeState.CANCELED);
    }

    public RealTimeTripTimesBuilder deleteTrip() {
        return this.withRealTimeState(RealTimeState.DELETED);
    }

    public StopRealTimeState getStopRealTimeState(int stop) {
        return this.stopRealTimeStates[stop];
    }

    public StopRealTimeState[] stopRealTimeStates() {
        return (StopRealTimeState[])this.stopRealTimeStates.clone();
    }

    public RealTimeTripTimesBuilder withRecorded(int stop) {
        return this.withStopRealTimeState(stop, StopRealTimeState.RECORDED);
    }

    public RealTimeTripTimesBuilder withCanceled(int stop) {
        return this.withStopRealTimeState(stop, StopRealTimeState.CANCELLED);
    }

    public RealTimeTripTimesBuilder withNoData(int stop) {
        return this.withStopRealTimeState(stop, StopRealTimeState.NO_DATA);
    }

    public RealTimeTripTimesBuilder withInaccuratePredictions(int stop) {
        return this.withStopRealTimeState(stop, StopRealTimeState.INACCURATE_PREDICTIONS);
    }

    public RealTimeTripTimesBuilder withStopRealTimeState(int stop, StopRealTimeState state) {
        this.stopRealTimeStates[stop] = state;
        return this;
    }

    @Nullable
    public I18NString tripHeadsign() {
        if (this.tripHeadsign == null) {
            return this.scheduledTripTimes.getTripHeadsign();
        }
        return this.tripHeadsign;
    }

    public RealTimeTripTimesBuilder withTripHeadsign(I18NString headsign) {
        this.tripHeadsign = headsign;
        return this;
    }

    @Nullable
    public I18NString[] stopHeadsigns() {
        I18NString[] result = this.scheduledTripTimes.copyHeadsigns(() -> new I18NString[this.scheduledTripTimes.getNumStops()]);
        for (int i = 0; i < result.length; ++i) {
            if (this.stopHeadsigns[i] == null) continue;
            result[i] = this.stopHeadsigns[i];
        }
        return result;
    }

    public RealTimeTripTimesBuilder withStopHeadsign(int stop, I18NString headsign) {
        this.stopHeadsigns[stop] = headsign;
        return this;
    }

    public OccupancyStatus[] occupancyStatus() {
        return (OccupancyStatus[])this.occupancyStatus.clone();
    }

    public RealTimeTripTimesBuilder withOccupancyStatus(int stop, OccupancyStatus occupancyStatus) {
        this.occupancyStatus[stop] = occupancyStatus;
        return this;
    }

    public Accessibility wheelchairAccessibility() {
        if (this.wheelchairAccessibility == null) {
            return this.scheduledTripTimes.getWheelchairAccessibility();
        }
        return this.wheelchairAccessibility;
    }

    public RealTimeTripTimesBuilder withWheelchairAccessibility(Accessibility wheelchairAccessibility) {
        this.wheelchairAccessibility = wheelchairAccessibility;
        return this;
    }

    public RealTimeTripTimesBuilder withServiceCode(int serviceCode) {
        this.scheduledTripTimes = this.scheduledTripTimes.copyOfNoDuplication().withServiceCode(serviceCode).build();
        return this;
    }

    public boolean copyMissingTimesFromScheduledTimetable() {
        boolean hasCopiedTimes = false;
        for (int i = 0; i < this.scheduledTripTimes.getNumStops(); ++i) {
            if (this.arrivalTimes[i] == null) {
                this.arrivalTimes[i] = this.getScheduledArrivalTime(i);
                hasCopiedTimes = true;
            }
            if (this.departureTimes[i] != null) continue;
            this.departureTimes[i] = this.getScheduledDepartureTime(i);
            hasCopiedTimes = true;
        }
        return hasCopiedTimes;
    }

    public RealTimeTripTimes build() {
        return new RealTimeTripTimes(this);
    }
}

