/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.timetable;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.framework.DataValidationException;
import org.opentripplanner.transit.model.timetable.OccupancyStatus;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.RealTimeTripTimesBuilder;
import org.opentripplanner.transit.model.timetable.ScheduledTripTimes;
import org.opentripplanner.transit.model.timetable.StopRealTimeState;
import org.opentripplanner.transit.model.timetable.TimetableValidationError;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.model.timetable.booking.BookingInfo;
import org.opentripplanner.utils.lang.IntUtils;

public final class RealTimeTripTimes
implements TripTimes {
    private final ScheduledTripTimes scheduledTripTimes;
    private final int[] arrivalTimes;
    private final int[] departureTimes;
    private final RealTimeState realTimeState;
    private final StopRealTimeState[] stopRealTimeStates;
    @Nullable
    private final I18NString tripHeadsign;
    private final I18NString[] stopHeadsigns;
    private final OccupancyStatus[] occupancyStatus;
    private final Accessibility wheelchairAccessibility;

    RealTimeTripTimes(RealTimeTripTimesBuilder builder) {
        this.scheduledTripTimes = builder.scheduledTripTimes();
        this.arrivalTimes = builder.arrivalTimes();
        this.departureTimes = builder.departureTimes();
        this.realTimeState = builder.realTimeState();
        this.stopRealTimeStates = builder.stopRealTimeStates();
        this.tripHeadsign = builder.tripHeadsign();
        this.stopHeadsigns = builder.stopHeadsigns();
        this.occupancyStatus = builder.occupancyStatus();
        this.wheelchairAccessibility = builder.wheelchairAccessibility();
        this.validateNonIncreasingTimes();
    }

    private RealTimeTripTimes(RealTimeTripTimes original, ScheduledTripTimes scheduledTripTimes) {
        this.scheduledTripTimes = scheduledTripTimes;
        this.arrivalTimes = original.arrivalTimes;
        this.departureTimes = original.departureTimes;
        this.realTimeState = original.realTimeState;
        this.stopRealTimeStates = original.stopRealTimeStates;
        this.tripHeadsign = original.tripHeadsign;
        this.stopHeadsigns = original.stopHeadsigns;
        this.occupancyStatus = original.occupancyStatus;
        this.wheelchairAccessibility = original.wheelchairAccessibility;
    }

    private RealTimeTripTimes(RealTimeTripTimes original, int timeShift) {
        this.scheduledTripTimes = original.scheduledTripTimes.copyOfNoDuplication().plusTimeShift(timeShift).build();
        this.arrivalTimes = IntUtils.shiftArray((int)timeShift, (int[])original.arrivalTimes);
        this.departureTimes = IntUtils.shiftArray((int)timeShift, (int[])original.departureTimes);
        this.realTimeState = original.realTimeState;
        this.stopRealTimeStates = original.stopRealTimeStates;
        this.tripHeadsign = original.tripHeadsign;
        this.stopHeadsigns = original.stopHeadsigns;
        this.occupancyStatus = original.occupancyStatus;
        this.wheelchairAccessibility = original.wheelchairAccessibility;
    }

    ScheduledTripTimes scheduledTripTimes() {
        return this.scheduledTripTimes;
    }

    @Override
    public RealTimeTripTimesBuilder createRealTimeWithoutScheduledTimes() {
        return new RealTimeTripTimesBuilder(this.scheduledTripTimes);
    }

    @Override
    public RealTimeTripTimesBuilder createRealTimeFromScheduledTimes() {
        return RealTimeTripTimesBuilder.fromScheduledTimes(this.scheduledTripTimes);
    }

    @Override
    @Nullable
    public I18NString getHeadsign(int stop) {
        return this.stopHeadsigns[stop] != null ? this.stopHeadsigns[stop] : this.tripHeadsign;
    }

    @Override
    public List<String> getHeadsignVias(int stop) {
        return this.scheduledTripTimes.getHeadsignVias(stop);
    }

    @Override
    @Nullable
    public I18NString getTripHeadsign() {
        return this.tripHeadsign;
    }

    @Override
    public int getScheduledArrivalTime(int stop) {
        return this.scheduledTripTimes.getScheduledArrivalTime(stop);
    }

    @Override
    public int getScheduledDepartureTime(int stop) {
        return this.scheduledTripTimes.getScheduledDepartureTime(stop);
    }

    @Override
    public int getArrivalTime(int stop) {
        return this.arrivalTimes[stop];
    }

    @Override
    public int getDepartureTime(int stop) {
        return this.departureTimes[stop];
    }

    @Override
    public int getArrivalDelay(int stop) {
        return this.getArrivalTime(stop) - this.scheduledTripTimes.getScheduledArrivalTime(stop);
    }

    @Override
    public int getDepartureDelay(int stop) {
        return this.getDepartureTime(stop) - this.scheduledTripTimes.getScheduledDepartureTime(stop);
    }

    @Override
    public boolean isCancelledStop(int stop) {
        return this.isStopRealTimeStates(stop, StopRealTimeState.CANCELLED);
    }

    @Override
    public boolean isRecordedStop(int stop) {
        return this.isStopRealTimeStates(stop, StopRealTimeState.RECORDED);
    }

    @Override
    public boolean isNoDataStop(int stop) {
        return this.isStopRealTimeStates(stop, StopRealTimeState.NO_DATA);
    }

    @Override
    public boolean isPredictionInaccurate(int stop) {
        return this.isStopRealTimeStates(stop, StopRealTimeState.INACCURATE_PREDICTIONS);
    }

    @Override
    public boolean isRealTimeUpdated(int stop) {
        return this.realTimeState != RealTimeState.SCHEDULED && !this.isStopRealTimeStates(stop, StopRealTimeState.NO_DATA);
    }

    @Override
    public OccupancyStatus getOccupancyStatus(int stop) {
        if (this.occupancyStatus == null) {
            return OccupancyStatus.NO_DATA_AVAILABLE;
        }
        return this.occupancyStatus[stop];
    }

    OccupancyStatus[] copyOccupancyStatus() {
        return (OccupancyStatus[])this.occupancyStatus.clone();
    }

    @Override
    public BookingInfo getDropOffBookingInfo(int stop) {
        return this.scheduledTripTimes.getDropOffBookingInfo(stop);
    }

    @Override
    public BookingInfo getPickupBookingInfo(int stop) {
        return this.scheduledTripTimes.getPickupBookingInfo(stop);
    }

    @Override
    public boolean isScheduled() {
        return this.realTimeState == RealTimeState.SCHEDULED;
    }

    @Override
    public boolean isCanceledOrDeleted() {
        return this.isCanceled() || this.isDeleted();
    }

    @Override
    public boolean isCanceled() {
        return this.realTimeState == RealTimeState.CANCELED;
    }

    @Override
    public boolean isDeleted() {
        return this.realTimeState == RealTimeState.DELETED;
    }

    @Override
    public RealTimeState getRealTimeState() {
        return this.realTimeState;
    }

    private void validateNonIncreasingTimes() {
        int nStops = this.scheduledTripTimes.getNumStops();
        int prevDep = -9999999;
        for (int s = 0; s < nStops; ++s) {
            int arr = this.getArrivalTime(s);
            int dep = this.getDepartureTime(s);
            if (dep < arr) {
                throw new DataValidationException(new TimetableValidationError(TimetableValidationError.ErrorCode.NEGATIVE_DWELL_TIME, s, this.getTrip()));
            }
            if (prevDep > arr) {
                throw new DataValidationException(new TimetableValidationError(TimetableValidationError.ErrorCode.NEGATIVE_HOP_TIME, s, this.getTrip()));
            }
            prevDep = dep;
        }
    }

    @Override
    @Nullable
    public Accessibility getWheelchairAccessibility() {
        return this.wheelchairAccessibility;
    }

    @Override
    public int getNumStops() {
        return this.scheduledTripTimes.getNumStops();
    }

    @Override
    public RealTimeTripTimes adjustTimesToGraphTimeZone(Duration shiftDelta) {
        return new RealTimeTripTimes(this, (int)shiftDelta.toSeconds());
    }

    @Override
    public int gtfsSequenceOfStopIndex(int stop) {
        return this.scheduledTripTimes.gtfsSequenceOfStopIndex(stop);
    }

    @Override
    public OptionalInt stopIndexOfGtfsSequence(int stopSequence) {
        return this.scheduledTripTimes.stopIndexOfGtfsSequence(stopSequence);
    }

    @Override
    public boolean isTimepoint(int stopIndex) {
        return this.scheduledTripTimes.isTimepoint(stopIndex);
    }

    @Override
    public int getServiceCode() {
        return this.scheduledTripTimes.getServiceCode();
    }

    @Override
    public RealTimeTripTimes withServiceCode(int serviceCode) {
        return new RealTimeTripTimes(this, this.scheduledTripTimes.copyOfNoDuplication().withServiceCode(serviceCode).build());
    }

    @Override
    public Trip getTrip() {
        return this.scheduledTripTimes.getTrip();
    }

    StopRealTimeState[] copyStopRealTimeStates() {
        return (StopRealTimeState[])this.stopRealTimeStates.clone();
    }

    private boolean isStopRealTimeStates(int stop, StopRealTimeState state) {
        return this.stopRealTimeStates != null && this.stopRealTimeStates[stop] == state;
    }

    I18NString[] copyStopHeadsigns() {
        return (I18NString[])this.stopHeadsigns.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RealTimeTripTimes that = (RealTimeTripTimes)o;
        return Objects.equals(this.scheduledTripTimes, that.scheduledTripTimes) && Objects.deepEquals(this.arrivalTimes, that.arrivalTimes) && Objects.deepEquals(this.departureTimes, that.departureTimes) && this.realTimeState == that.realTimeState && Objects.deepEquals(this.stopRealTimeStates, that.stopRealTimeStates) && Objects.equals(this.tripHeadsign, that.tripHeadsign) && Objects.deepEquals(this.stopHeadsigns, that.stopHeadsigns) && Objects.deepEquals(this.occupancyStatus, that.occupancyStatus) && this.wheelchairAccessibility == that.wheelchairAccessibility;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.scheduledTripTimes, Arrays.hashCode(this.arrivalTimes), Arrays.hashCode(this.departureTimes), this.realTimeState, Arrays.hashCode((Object[])this.stopRealTimeStates), this.tripHeadsign, Arrays.hashCode(this.stopHeadsigns), Arrays.hashCode(this.occupancyStatus), this.wheelchairAccessibility});
    }
}

