/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.timetable;

import org.opentripplanner.framework.doc.DocumentedEnum;

public enum OccupancyStatus implements DocumentedEnum<OccupancyStatus>
{
    NO_DATA_AVAILABLE,
    EMPTY,
    MANY_SEATS_AVAILABLE,
    FEW_SEATS_AVAILABLE,
    STANDING_ROOM_ONLY,
    CRUSHED_STANDING_ROOM_ONLY,
    FULL,
    NOT_ACCEPTING_PASSENGERS;


    @Override
    public String typeDescription() {
        return "OccupancyStatus to be exposed in the API. The values are based on GTFS-RT";
    }

    @Override
    public String enumValueDescription() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "The vehicle or carriage doesn't have any occupancy data available.";
            case 1 -> "The vehicle is considered empty by most measures, and has few or no passengers onboard, but is\nstill accepting passengers. There isn't a big difference between this and `manySeatsAvailable`\nso it's possible to handle them as the same value, if one wants to limit the number of different\nvalues.\nSIRI nordic profile: merge these into `manySeatsAvailable`.\n";
            case 2 -> "The vehicle or carriage has a large number of seats available.\nSIRI nordic profile: more than ~50% of seats available.\n";
            case 3 -> "The vehicle or carriage has a few seats available.\nSIRI nordic profile: less than ~50% of seats available.\n";
            case 4 -> "The vehicle or carriage only has standing room available.\nSIRI nordic profile: less than ~10% of seats available.\n";
            case 5 -> "The vehicle or carriage can currently accommodate only standing passengers and has limited\nspace for them. There isn't a big difference between this and `full` so it's possible to\nhandle them as the same value, if one wants to limit the number of different values.\nSIRI nordic profile: merge into `standingRoomOnly`.\n";
            case 6 -> "The vehicle or carriage is considered full by most measures, but may still be allowing\npassengers to board.\n";
            case 7 -> "The vehicle or carriage has no seats or standing room available.\nSIRI nordic profile: if vehicle/carriage is not in use / unavailable, or passengers are only\nallowed to alight due to e.g. crowding.\n";
        };
    }
}

