/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.timetable;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Objects;

public class EstimatedTime {
    private final ZonedDateTime time;
    private final Duration delay;

    private EstimatedTime(ZonedDateTime time, Duration delay) {
        this.time = Objects.requireNonNull(time);
        this.delay = Objects.requireNonNull(delay);
    }

    public static EstimatedTime of(ZonedDateTime scheduledTime, int delaySecs) {
        Duration delay = Duration.ofSeconds(delaySecs);
        return new EstimatedTime(scheduledTime.minus(delay), delay);
    }

    public ZonedDateTime time() {
        return this.time;
    }

    public Duration delay() {
        return this.delay;
    }
}

