/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.site;

import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.framework.AbstractEntityBuilder;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StationElementBuilder;
import org.opentripplanner.transit.model.site.StopLevel;
import org.opentripplanner.transit.model.site.StopLocation;

public abstract class StationElement<E extends StationElement<E, B>, B extends StationElementBuilder<E, B>>
extends AbstractTransitEntity<E, B> {
    private final I18NString name;
    private final String code;
    private final I18NString description;
    private final WgsCoordinate coordinate;
    private final Accessibility wheelchairAccessibility;
    private final StopLevel level;
    private final Station parentStation;

    StationElement(B builder) {
        super(((AbstractEntityBuilder)builder).getId());
        this.name = ((StationElementBuilder)builder).name();
        this.wheelchairAccessibility = Objects.requireNonNullElse(((StationElementBuilder)builder).wheelchairAccessibility(), Accessibility.NO_INFORMATION);
        this.coordinate = ((StationElementBuilder)builder).coordinate();
        this.code = ((StationElementBuilder)builder).code();
        this.description = ((StationElementBuilder)builder).description();
        this.level = ((StationElementBuilder)builder).level();
        this.parentStation = ((StationElementBuilder)builder).parentStation();
    }

    public I18NString getName() {
        return this.name;
    }

    @Nullable
    public String getCode() {
        return this.code;
    }

    @Nullable
    public I18NString getDescription() {
        return this.description;
    }

    boolean isCoordinateSet() {
        return this.coordinate != null;
    }

    public WgsCoordinate getCoordinate() {
        if (this.coordinate != null) {
            return this.coordinate;
        }
        if (this.parentStation != null) {
            return this.parentStation.getCoordinate();
        }
        throw new IllegalStateException("Coordinate not set for: " + this.toString());
    }

    public Accessibility getWheelchairAccessibility() {
        return this.wheelchairAccessibility;
    }

    @Nullable
    public StopLevel level() {
        return this.level;
    }

    @Nullable
    public String getLevelName() {
        return this.level == null ? null : this.level.name();
    }

    @Nullable
    public Double getLevelIndex() {
        return this.level == null ? null : Double.valueOf(this.level.index());
    }

    @Nullable
    public Station getParentStation() {
        return this.parentStation;
    }

    public boolean isPartOfStation() {
        return this.parentStation != null;
    }

    public boolean isPartOfSameStationAs(StopLocation other) {
        if (other == null) {
            return false;
        }
        return this.isPartOfStation() && this.parentStation.equals(other.getParentStation());
    }

    @Override
    public boolean sameAs(E other) {
        return this.getId().equals(((AbstractTransitEntity)other).getId()) && Objects.equals(this.name, ((StationElement)other).getName()) && Objects.equals(this.code, ((StationElement)other).getCode()) && Objects.equals(this.description, ((StationElement)other).getDescription()) && Objects.equals(this.coordinate, ((StationElement)other).getCoordinate()) && Objects.equals((Object)this.wheelchairAccessibility, (Object)((StationElement)other).getWheelchairAccessibility()) && Objects.equals(this.level, ((StationElement)other).level()) && Objects.equals(this.parentStation, ((StationElement)other).getParentStation());
    }
}

