/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.site;

import com.fasterxml.jackson.annotation.JsonBackReference;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.LogInfo;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StationBuilder;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.site.StopLocationsGroup;
import org.opentripplanner.transit.model.site.StopTransferPriority;

public class Station
extends AbstractTransitEntity<Station, StationBuilder>
implements StopLocationsGroup,
LogInfo {
    private final I18NString name;
    private final String code;
    private final I18NString description;
    private final WgsCoordinate coordinate;
    private final boolean shouldRouteToCentroid;
    private final StopTransferPriority priority;
    private final I18NString url;
    private final ZoneId timezone;
    private final boolean transfersNotAllowed;
    @JsonBackReference
    private final Set<StopLocation> childStops = new HashSet<StopLocation>();
    private GeometryCollection geometry;

    Station(StationBuilder builder) {
        super(builder.getId());
        this.name = Objects.requireNonNull(builder.getName());
        this.coordinate = Objects.requireNonNull(builder.getCoordinate());
        this.shouldRouteToCentroid = builder.shouldRouteToCentroid();
        this.priority = Objects.requireNonNullElse(builder.getPriority(), StopTransferPriority.defaultValue());
        this.transfersNotAllowed = builder.isTransfersNotAllowed();
        this.code = builder.getCode();
        this.description = builder.getDescription();
        this.url = builder.getUrl();
        this.timezone = builder.getTimezone();
        this.geometry = Station.computeGeometry(this.coordinate, Set.of());
    }

    public static StationBuilder of(FeedScopedId id) {
        return new StationBuilder(id);
    }

    void addChildStop(RegularStop stop) {
        this.childStops.add(stop);
        this.geometry = Station.computeGeometry(this.coordinate, this.childStops);
    }

    public boolean includes(StopLocation stop) {
        return this.childStops.contains(stop);
    }

    @Override
    public I18NString getName() {
        return this.name;
    }

    @Override
    public Collection<StopLocation> getChildStops() {
        return this.childStops;
    }

    @Override
    public double getLat() {
        return this.coordinate.latitude();
    }

    @Override
    public double getLon() {
        return this.coordinate.longitude();
    }

    @Override
    public WgsCoordinate getCoordinate() {
        return this.coordinate;
    }

    public boolean shouldRouteToCentroid() {
        return this.shouldRouteToCentroid;
    }

    @Nullable
    public String getCode() {
        return this.code;
    }

    @Nullable
    public I18NString getDescription() {
        return this.description;
    }

    @Nullable
    public I18NString getUrl() {
        return this.url;
    }

    public StopTransferPriority getPriority() {
        return this.priority;
    }

    @Nullable
    public ZoneId getTimezone() {
        return this.timezone;
    }

    public boolean isTransfersNotAllowed() {
        return this.transfersNotAllowed;
    }

    public GeometryCollection getGeometry() {
        return this.geometry;
    }

    @Override
    @Nullable
    public String logName() {
        return this.name == null ? null : this.name.toString();
    }

    public StationBuilder copy() {
        return new StationBuilder(this);
    }

    @Override
    public boolean sameAs(Station other) {
        return this.getId().equals(other.getId()) && Objects.equals(this.name, other.name) && Objects.equals(this.code, other.code) && Objects.equals(this.description, other.description) && Objects.equals(this.coordinate, other.coordinate) && Objects.equals(this.shouldRouteToCentroid, other.shouldRouteToCentroid) && Objects.equals((Object)this.priority, (Object)other.priority) && Objects.equals(this.url, other.url) && Objects.equals(this.timezone, other.timezone);
    }

    private static GeometryCollection computeGeometry(WgsCoordinate coordinate, Set<StopLocation> childStops) {
        Geometry[] geometryArray;
        Point stationPoint = null;
        List<Geometry> childGeometries = childStops.stream().map(StopLocation::getGeometry).filter(Objects::nonNull).collect(Collectors.toList());
        if (coordinate != null) {
            stationPoint = GeometryUtils.getGeometryFactory().createPoint(coordinate.asJtsCoordinate());
            childGeometries.add((Geometry)stationPoint);
        }
        GeometryCollection geometryCollection = GeometryUtils.getGeometryFactory().createGeometryCollection(childGeometries.toArray(new Geometry[0]));
        Geometry convexHull = new ConvexHull((Geometry)geometryCollection).getConvexHull();
        if (stationPoint != null) {
            Geometry[] geometryArray2 = new Geometry[2];
            geometryArray2[0] = stationPoint;
            geometryArray = geometryArray2;
            geometryArray2[1] = convexHull;
        } else {
            Geometry[] geometryArray3 = new Geometry[1];
            geometryArray = geometryArray3;
            geometryArray3[0] = convexHull;
        }
        Geometry[] geometries = geometryArray;
        return GeometryUtils.getGeometryFactory().createGeometryCollection(geometries);
    }
}

