/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.site;

import java.time.ZoneId;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntSupplier;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.BoardingArea;
import org.opentripplanner.transit.model.site.FareZone;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StationElementBuilder;

public final class RegularStopBuilder
extends StationElementBuilder<RegularStop, RegularStopBuilder> {
    private final IntSupplier indexCounter;
    private String platformCode;
    private I18NString url;
    private ZoneId timeZone;
    private TransitMode vehicleType;
    private String netexVehicleSubmode;
    private final Set<BoardingArea> boardingAreas = new HashSet<BoardingArea>();
    private final Set<FareZone> fareZones = new HashSet<FareZone>();

    RegularStopBuilder(FeedScopedId id, IntSupplier indexCounter) {
        super(id);
        this.indexCounter = Objects.requireNonNull(indexCounter);
    }

    RegularStopBuilder(RegularStop original) {
        super(original);
        this.indexCounter = original::getIndex;
        this.platformCode = original.getPlatformCode();
        this.url = original.getUrl();
        this.timeZone = original.getTimeZone();
        this.vehicleType = original.getVehicleType();
        this.netexVehicleSubmode = original.getNetexVehicleSubmode().name();
    }

    public String platformCode() {
        return this.platformCode;
    }

    public RegularStopBuilder withPlatformCode(String platformCode) {
        this.platformCode = platformCode;
        return this;
    }

    public I18NString url() {
        return this.url;
    }

    public RegularStopBuilder withUrl(I18NString url) {
        this.url = url;
        return this;
    }

    public TransitMode vehicleType() {
        return this.vehicleType;
    }

    public RegularStopBuilder withVehicleType(TransitMode vehicleType) {
        this.vehicleType = vehicleType;
        return this;
    }

    public String netexVehicleSubmode() {
        return this.netexVehicleSubmode;
    }

    public RegularStopBuilder withNetexVehicleSubmode(String netexVehicleSubmode) {
        this.netexVehicleSubmode = netexVehicleSubmode;
        return this;
    }

    public ZoneId timeZone() {
        return this.timeZone;
    }

    public RegularStopBuilder withTimeZone(ZoneId timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public RegularStopBuilder addFareZones(FareZone fareZone) {
        this.fareZones.add(fareZone);
        return this;
    }

    public Set<FareZone> fareZones() {
        return this.fareZones;
    }

    public RegularStopBuilder addBoardingArea(BoardingArea boardingArea) {
        this.boardingAreas.add(boardingArea);
        return this;
    }

    public Collection<BoardingArea> boardingAreas() {
        return this.boardingAreas;
    }

    @Override
    RegularStopBuilder instance() {
        return this;
    }

    @Override
    protected RegularStop buildFromValues() {
        return new RegularStop(this);
    }

    int createIndex() {
        return this.indexCounter.getAsInt();
    }
}

