/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.site;

import java.util.Collection;
import java.util.Objects;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.MultiModalStationBuilder;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.site.StopLocationsGroup;

public class MultiModalStation
extends AbstractTransitEntity<MultiModalStation, MultiModalStationBuilder>
implements StopLocationsGroup {
    private final Collection<Station> childStations;
    private final I18NString name;
    private final WgsCoordinate coordinate;
    private final String code;
    private final String description;
    private final I18NString url;

    MultiModalStation(MultiModalStationBuilder builder) {
        super(builder.getId());
        this.childStations = Objects.requireNonNull(builder.childStations());
        this.coordinate = Objects.requireNonNull(builder.coordinate());
        this.name = I18NString.assertHasValue(builder.name());
        this.code = builder.code();
        this.description = builder.description();
        this.url = builder.url();
    }

    public static MultiModalStationBuilder of(FeedScopedId id) {
        return new MultiModalStationBuilder(id);
    }

    @Override
    public I18NString getName() {
        return this.name;
    }

    public Collection<Station> getChildStations() {
        return this.childStations;
    }

    @Override
    public Collection<StopLocation> getChildStops() {
        return this.childStations.stream().flatMap(s -> s.getChildStops().stream()).toList();
    }

    @Override
    public WgsCoordinate getCoordinate() {
        return this.coordinate;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public I18NString getUrl() {
        return this.url;
    }

    @Override
    public boolean sameAs(MultiModalStation other) {
        return this.getId().equals(other.getId()) && Objects.equals(this.childStations, other.getChildStations()) && Objects.equals(this.name, other.getName()) && Objects.equals(this.coordinate, other.getCoordinate()) && Objects.equals(this.code, other.getCode()) && Objects.equals(this.description, other.getDescription()) && Objects.equals(this.url, other.getUrl());
    }

    public MultiModalStationBuilder copy() {
        return new MultiModalStationBuilder(this);
    }
}

