/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.site;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.GroupOfStationsBuilder;
import org.opentripplanner.transit.model.site.GroupOfStationsPurpose;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.site.StopLocationsGroup;

public class GroupOfStations
extends AbstractTransitEntity<GroupOfStations, GroupOfStationsBuilder>
implements StopLocationsGroup {
    private final Set<StopLocationsGroup> childStations;
    private final I18NString name;
    private final GroupOfStationsPurpose purposeOfGrouping;
    private final WgsCoordinate coordinate;

    GroupOfStations(GroupOfStationsBuilder builder) {
        super(builder.getId());
        this.name = I18NString.assertHasValue(builder.name());
        this.childStations = Objects.requireNonNull(builder.childStations());
        this.purposeOfGrouping = builder.purposeOfGrouping();
        this.coordinate = builder.coordinate();
    }

    public static GroupOfStationsBuilder of(FeedScopedId id) {
        return new GroupOfStationsBuilder(id);
    }

    @Override
    public I18NString getName() {
        return this.name;
    }

    @Override
    @Nullable
    public WgsCoordinate getCoordinate() {
        return this.coordinate;
    }

    @Override
    public Collection<StopLocation> getChildStops() {
        return this.childStations.stream().flatMap(s -> s.getChildStops().stream()).toList();
    }

    public Collection<StopLocationsGroup> getChildStations() {
        return this.childStations;
    }

    @Nullable
    public GroupOfStationsPurpose getPurposeOfGrouping() {
        return this.purposeOfGrouping;
    }

    @Override
    public boolean sameAs(GroupOfStations other) {
        return this.getId().equals(other.getId()) && Objects.equals(this.name, other.getName()) && Objects.equals(this.childStations, other.getChildStations()) && Objects.equals(this.coordinate, other.getCoordinate()) && Objects.equals((Object)this.purposeOfGrouping, (Object)other.getPurposeOfGrouping());
    }

    public GroupOfStationsBuilder copy() {
        return new GroupOfStationsBuilder(this);
    }
}

