/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.organization;

import java.time.ZoneId;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.LogInfo;
import org.opentripplanner.transit.model.organization.AgencyBuilder;
import org.opentripplanner.utils.lang.StringUtils;

public final class Agency
extends AbstractTransitEntity<Agency, AgencyBuilder>
implements LogInfo {
    private final String name;
    private final ZoneId timezone;
    private final String url;
    private final String lang;
    private final String phone;
    private final String fareUrl;

    Agency(AgencyBuilder builder) {
        super(builder.getId());
        this.name = StringUtils.assertHasValue((String)builder.getName(), (String)"Missing mandatory name on Agency %s", (Object[])new Object[]{builder.getId()});
        this.timezone = ZoneId.of(StringUtils.assertHasValue((String)builder.getTimezone(), (String)"Missing mandatory time zone on Agency %s", (Object[])new Object[]{builder.getId()}));
        this.url = builder.getUrl();
        this.lang = builder.getLang();
        this.phone = builder.getPhone();
        this.fareUrl = builder.getFareUrl();
    }

    public static AgencyBuilder of(FeedScopedId id) {
        return new AgencyBuilder(id);
    }

    public String getName() {
        return this.logName();
    }

    public ZoneId getTimezone() {
        return this.timezone;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getLang() {
        return this.lang;
    }

    @Nullable
    public String getPhone() {
        return this.phone;
    }

    @Nullable
    public String getFareUrl() {
        return this.fareUrl;
    }

    public AgencyBuilder copy() {
        return new AgencyBuilder(this);
    }

    @Override
    public String logName() {
        return this.name;
    }

    @Override
    public boolean sameAs(Agency other) {
        return this.getId().equals(other.getId()) && Objects.equals(this.name, other.name) && Objects.equals(this.timezone, other.timezone) && Objects.equals(this.url, other.url) && Objects.equals(this.lang, other.lang) && Objects.equals(this.phone, other.phone) && Objects.equals(this.fareUrl, other.fareUrl);
    }
}

